/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.io.IOException;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public class BestDriversFilter
extends Filter {
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        LeafReader reader = context.reader();
        FixedBitSet bits = new FixedBitSet(reader.maxDoc());
        DocsEnum termDocsEnum = reader.termDocsEnum(new Term("score", "5"));
        if (termDocsEnum == null) {
            return new BitDocIdSet((BitSet)bits);
        }
        while (termDocsEnum.nextDoc() != Integer.MAX_VALUE) {
            int docID = termDocsEnum.docID();
            if (acceptDocs != null && !acceptDocs.get(docID)) continue;
            bits.set(docID);
        }
        return new BitDocIdSet((BitSet)bits);
    }

    public String toString(String field) {
        return "";
    }
}

