/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.CalendarBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.EncodingType;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class NumericEncodingQueriesTest
extends SearchTestBase {
    private static final Calendar ANNOUNCED = NumericEncodingQueriesTest.initCalendar(1950, 1, 1);
    private static final Date UPDATED = NumericEncodingQueriesTest.initCalendar(2000, 1, 1).getTime();
    private static final Calendar FIRST_EDITION = NumericEncodingQueriesTest.initCalendar(1966, 0, 1);
    private static final Calendar NEXT_EVENT = NumericEncodingQueriesTest.initCalendar(2015, 9, 29);
    private static final Fair LUCCA_COMICS = new Fair(1L, "Lucca comics and games", NEXT_EVENT.getTime(), FIRST_EDITION, UPDATED, ANNOUNCED);

    private static Calendar initCalendar(int year, int month, int day) {
        Calendar instance = NumericEncodingQueriesTest.createCalendar();
        instance.set(1966, 0, 1);
        return instance;
    }

    private static Calendar createCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("Europe/Rome"), Locale.ITALY);
    }

    @Before
    public void createEvent() throws Exception {
        try (Session session = this.openSession();){
            Transaction tx = session.beginTransaction();
            session.persist((Object)LUCCA_COMICS);
            tx.commit();
        }
    }

    @After
    public void cleanUp() throws Exception {
        try (Session session = this.openSession();){
            Transaction tx = session.beginTransaction();
            session.delete((Object)LUCCA_COMICS);
            tx.commit();
        }
    }

    @Test
    public void testDslWithDate() throws Exception {
        try (Session session = this.openSession();){
            Date nextEventDate = DateTools.round((Date)NEXT_EVENT.getTime(), (DateTools.Resolution)DateTools.Resolution.DAY);
            Query query = this.queryBuilder().keyword().onField("startDate").matching((Object)nextEventDate).createQuery();
            Fair event = (Fair)Search.getFullTextSession((Session)session).createFullTextQuery(query, new Class[]{Fair.class}).uniqueResult();
            Assertions.assertThat((Object)event).isEqualTo((Object)LUCCA_COMICS);
        }
    }

    @Test
    public void testDslWithCalendar() throws Exception {
        try (Session session = this.openSession();){
            Calendar year = NumericEncodingQueriesTest.createCalendar();
            year.setTime(DateTools.round((Date)FIRST_EDITION.getTime(), (DateTools.Resolution)DateTools.Resolution.YEAR));
            Query query = this.queryBuilder().keyword().onField("since").matching((Object)year).createQuery();
            Fair event = (Fair)Search.getFullTextSession((Session)session).createFullTextQuery(query, new Class[]{Fair.class}).uniqueResult();
            Assertions.assertThat((Object)event).isEqualTo((Object)LUCCA_COMICS);
        }
    }

    @Test
    public void testDslWithDefaultDateBridge() throws Exception {
        try (Session session = this.openSession();){
            Query query = this.queryBuilder().keyword().onField("updated").matching((Object)UPDATED).createQuery();
            Fair event = (Fair)Search.getFullTextSession((Session)session).createFullTextQuery(query, new Class[]{Fair.class}).uniqueResult();
            Assertions.assertThat((Object)event).isEqualTo((Object)LUCCA_COMICS);
        }
    }

    @Test
    public void testDslWithDefaultCalendarBridge() throws Exception {
        try (Session session = this.openSession();){
            Query query = this.queryBuilder().keyword().onField("announced").matching((Object)ANNOUNCED).createQuery();
            Fair event = (Fair)Search.getFullTextSession((Session)session).createFullTextQuery(query, new Class[]{Fair.class}).uniqueResult();
            Assertions.assertThat((Object)event).isEqualTo((Object)LUCCA_COMICS);
        }
    }

    private QueryBuilder queryBuilder() {
        QueryBuilder queryBuilder = this.getSearchFactory().buildQueryBuilder().forEntity(Fair.class).get();
        return queryBuilder;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Fair.class};
    }

    @Entity
    @Indexed
    static class Fair {
        @Id
        private Long id;
        @Field
        private String name;
        @Field
        @DateBridge(encoding=EncodingType.NUMERIC, resolution=Resolution.DAY)
        @Temporal(value=TemporalType.DATE)
        private Date startDate;
        @Field
        @CalendarBridge(encoding=EncodingType.NUMERIC, resolution=Resolution.YEAR)
        private Calendar since;
        @Field
        private Date updated;
        @Field
        private Calendar announced;

        public Fair() {
        }

        public Fair(Long id, String name, Date startDate, Calendar since, Date updated, Calendar announced) {
            this.id = id;
            this.name = name;
            this.startDate = startDate;
            this.since = since;
            this.updated = updated;
            this.announced = announced;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public Calendar getSince() {
            return this.since;
        }

        public void setSince(Calendar firstEvent) {
            this.since = firstEvent;
        }

        public Date getUpdated() {
            return this.updated;
        }

        public void setUpdated(Date updated) {
            this.updated = updated;
        }

        public Calendar getAnnounced() {
            return this.announced;
        }

        public void setAnnounced(Calendar announced) {
            this.announced = announced;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Fair other = (Fair)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Fair [id=");
            builder.append(this.id);
            builder.append(", name=");
            builder.append(this.name);
            builder.append(", startDate=");
            builder.append(this.startDate);
            builder.append(", since=");
            builder.append(this.since);
            builder.append("]");
            return builder.toString();
        }
    }
}

