/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.initandlookup;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.initandlookup.StrictKernel;
import org.hibernate.search.testsupport.backend.GatedLuceneBackend;
import org.hibernate.stat.Statistics;
import org.hibernate.testing.cache.CachingRegionFactory;
import org.junit.Test;

public class StrictSecondLCAndPCLookupTest
extends SearchTestBase {
    @Test
    public void testStaleCacheWithAsyncIndexer() {
        Session session = this.openSession();
        Statistics statistics = session.getSessionFactory().getStatistics();
        statistics.clear();
        statistics.setStatisticsEnabled(true);
        this.setData(session, statistics);
        GatedLuceneBackend.open.set(false);
        Transaction tx = session.beginTransaction();
        List list = session.createCriteria(StrictKernel.class).list();
        Assertions.assertThat((List)list).hasSize(2);
        session.delete(list.get(0));
        tx.commit();
        session.clear();
        GatedLuceneBackend.open.set(true);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery allKernelsQuery = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]).initializeObjectsWith(ObjectLookupMethod.SECOND_LEVEL_CACHE, DatabaseRetrievalMethod.QUERY);
        Assertions.assertThat((int)allKernelsQuery.getResultSize()).isEqualTo(2);
        Assertions.assertThat((List)allKernelsQuery.list()).hasSize(1);
    }

    private void setData(Session session, Statistics statistics) {
        Transaction transaction = session.beginTransaction();
        StrictKernel k = new StrictKernel();
        k.setCodeName("coconut");
        k.setProduct("Polgeiser");
        session.persist((Object)k);
        StrictKernel k2 = new StrictKernel();
        k2.setCodeName("ballpark");
        k2.setProduct("Polgeiser");
        session.persist((Object)k2);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        session.get(StrictKernel.class, (Serializable)k.getId());
        session.get(StrictKernel.class, (Serializable)k2.getId());
        transaction.commit();
        Assertions.assertThat((long)statistics.getSecondLevelCachePutCount()).isEqualTo(2L);
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        super.configure(cfg);
        cfg.put("hibernate.cache.use_second_level_cache", "true");
        cfg.put("hibernate.search.default.worker.backend", GatedLuceneBackend.class.getName());
        cfg.put("hibernate.cache.region.factory_class", CachingRegionFactory.class.getCanonicalName());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{StrictKernel.class};
    }
}

