/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jdbc.Work;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.TestResourceManager;
import org.hibernate.search.test.util.MultitenancyTestHelper;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.util.impl.FileHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class DefaultTestResourceManager
implements TestResourceManager {
    private static final Log log = LoggerFactory.make();
    private final TestConfiguration test;
    private final Path baseIndexDir;
    private SessionFactoryImplementor sessionFactory;
    private MultitenancyTestHelper multitenancy;
    private Session session;
    private SearchFactory searchFactory;
    private Map<String, Object> configurationSettings;

    public DefaultTestResourceManager(TestConfiguration test, Class currentTestModuleClass) {
        this.test = test;
        this.baseIndexDir = this.createBaseIndexDir(currentTestModuleClass);
    }

    @Override
    public void openSessionFactory() {
        if (this.sessionFactory != null) {
            throw new IllegalStateException("there should be no SessionFactory initialized at this point");
        }
        this.sessionFactory = this.buildSessionFactory();
    }

    private SessionFactoryImplementor buildSessionFactory() {
        this.multitenancy = new MultitenancyTestHelper(this.test.multiTenantIds());
        Map<String, Object> settings = this.getConfigurationSettings();
        this.multitenancy.forceConfigurationSettings(settings);
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder().applySettings(settings);
        this.multitenancy.enableIfNeeded(registryBuilder);
        ServiceRegistryImplementor serviceRegistry = (ServiceRegistryImplementor)registryBuilder.build();
        MetadataSources ms = new MetadataSources((ServiceRegistry)serviceRegistry);
        Class<?>[] annotatedClasses = this.test.getAnnotatedClasses();
        if (annotatedClasses != null) {
            for (Class<?> entity : annotatedClasses) {
                ms.addAnnotatedClass(entity);
            }
        }
        Metadata metadata = ms.buildMetadata();
        this.multitenancy.exportSchema(serviceRegistry, metadata, settings);
        SessionFactoryBuilder sfb = metadata.getSessionFactoryBuilder();
        return (SessionFactoryImplementor)sfb.build();
    }

    private Map<String, Object> getConfigurationSettings() {
        if (this.configurationSettings == null) {
            this.configurationSettings = new HashMap<String, Object>();
            this.configurationSettings.put("hibernate.search.lucene_version", TestConstants.getTargetLuceneVersion().toString());
            this.configurationSettings.put("hibernate.search.default.directory_provider", "ram");
            this.configurationSettings.put("hibernate.search.default.indexBase", this.getBaseIndexDir().toAbsolutePath().toString());
            this.configurationSettings.put("hibernate.search.analyzer", StopAnalyzer.class.getName());
            this.configurationSettings.put("hibernate.search.default.indexwriter.merge_factor", "100");
            this.configurationSettings.put("hibernate.search.default.indexwriter.max_buffered_docs", "1000");
            this.configurationSettings.put("hibernate.hbm2ddl.auto", "create-drop");
            this.test.configure(this.configurationSettings);
        }
        return this.configurationSettings;
    }

    @Override
    public void closeSessionFactory() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        if (this.multitenancy != null) {
            this.multitenancy.close();
            this.multitenancy = null;
        }
        this.configurationSettings = null;
        this.session = null;
        this.searchFactory = null;
    }

    @Override
    public Session openSession() {
        if (this.session != null && this.session.isOpen()) {
            throw new IllegalStateException("Previously opened Session wasn't closed!");
        }
        this.session = this.getSessionFactory().openSession();
        return this.session;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("SessionFactory should be already defined at this point");
        }
        return this.sessionFactory;
    }

    @Override
    public Directory getDirectory(Class<?> clazz) {
        ExtendedSearchIntegrator integrator = ContextHelper.getSearchintegratorBySFI((SessionFactoryImplementor)this.sessionFactory);
        IndexManager[] indexManagers = integrator.getIndexBinding(clazz).getIndexManagers();
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers[0];
        return indexManager.getDirectoryProvider().getDirectory();
    }

    @Override
    public void ensureIndexesAreEmpty() throws IOException {
        FileHelper.delete((Path)this.getBaseIndexDir());
    }

    @Override
    public SearchFactory getSearchFactory() {
        if (this.searchFactory == null) {
            try (Session session = this.getSessionFactory().openSession();){
                this.searchFactory = Search.getFullTextSession((Session)session).getSearchFactory();
            }
        }
        return this.searchFactory;
    }

    public ExtendedSearchIntegrator getExtendedSearchIntegrator() {
        return (ExtendedSearchIntegrator)this.getSearchFactory().unwrap(ExtendedSearchIntegrator.class);
    }

    @Override
    public Path getBaseIndexDir() {
        return this.baseIndexDir;
    }

    public void defaultTearDown() throws Exception {
        this.handleUnclosedResources();
        this.closeSessionFactory();
        this.ensureIndexesAreEmpty();
    }

    public void handleUnclosedResources() {
        if (this.session != null && this.session.isOpen()) {
            if (this.session.isConnected()) {
                this.session.doWork((Work)new RollbackWork());
            }
            this.session.close();
            this.session = null;
            log.debug((Object)"Closing open session. Make sure to close sessions explicitly in your tests!");
        } else {
            this.session = null;
        }
        this.searchFactory = null;
    }

    private Path createBaseIndexDir(Class currentTestModuleClass) {
        String shortTestName = currentTestModuleClass.getSimpleName() + "-" + UUID.randomUUID().toString().substring(0, 8);
        return Paths.get(TestConstants.getIndexDirectory((Class)currentTestModuleClass), shortTestName);
    }

    private static class RollbackWork
    implements Work {
        private RollbackWork() {
        }

        public void execute(Connection connection) throws SQLException {
            connection.rollback();
        }
    }
}

