/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.tika;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.sql.Blob;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.tika.Book;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class TikaBridgeInputTypeTest
extends SearchTestBase {
    private static final String TEST_DOCUMENT_PDF_1 = "/org/hibernate/search/test/bridge/tika/test-document-1.pdf";
    private static final String PATH_TO_TEST_DOCUMENT_PDF_1;
    private static final String TEST_DOCUMENT_PDF_2 = "/org/hibernate/search/test/bridge/tika/test-document-2.pdf";
    private static final String PATH_TO_TEST_DOCUMENT_PDF_2;

    @Test
    public void testDefaultTikaBridgeWithListOfString() throws Exception {
        try (Session session = this.openSession();){
            String content1 = new File(PATH_TO_TEST_DOCUMENT_PDF_1).getAbsolutePath();
            String content2 = new File(PATH_TO_TEST_DOCUMENT_PDF_2).getAbsolutePath();
            this.persistBook(session, new Book(content1, content2));
            this.indexBook(session);
            List<Book> resultWithLucene = this.search(session, "contentAsListOfString", "Lucene");
            Assert.assertEquals((String)"there should be a match", (long)1L, (long)resultWithLucene.size());
            List<Book> resultWithTika = this.search(session, "contentAsListOfString", "Tika");
            Assert.assertEquals((String)"there should be a match", (long)1L, (long)resultWithTika.size());
        }
    }

    private List<Book> search(Session session, String field, String keyword) throws ParseException {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        Transaction transaction = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(field, TestConstants.standardAnalyzer);
        Query query = parser.parse(keyword);
        List result = fullTextSession.createFullTextQuery(query, new Class[0]).list();
        transaction.commit();
        fullTextSession.clear();
        return result;
    }

    @Test
    public void testDefaultTikaBridgeWithBlob() throws Exception {
        try (Session session = this.openSession();){
            Blob content = this.dataAsBlob(new File(PATH_TO_TEST_DOCUMENT_PDF_1), session);
            this.persistBook(session, new Book(content));
            this.persistBook(session, new Book());
            this.indexBook(session);
            this.searchBook(session, "contentAsBlob");
        }
    }

    @Test
    public void testDefaultTikaBridgeWithByteArray() throws Exception {
        try (Session session = this.openSession();){
            byte[] content = this.dataAsBytes(new File(PATH_TO_TEST_DOCUMENT_PDF_1));
            this.persistBook(session, new Book(content));
            this.persistBook(session, new Book());
            this.indexBook(session);
            this.searchBook(session, "contentAsBytes");
        }
    }

    @Test
    public void testDefaultTikaBridgeWithURI() throws Exception {
        try (Session session = this.openSession();){
            URI content = new File(PATH_TO_TEST_DOCUMENT_PDF_1).toURI();
            this.persistBook(session, new Book(content));
            this.persistBook(session, new Book());
            this.indexBook(session);
            this.searchBook(session, "contentAsURI");
        }
    }

    private void searchBook(Session session, String field) throws ParseException {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        Transaction transaction = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(field, TestConstants.standardAnalyzer);
        Query query = parser.parse("foo");
        List result = fullTextSession.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"there should be no match", (long)0L, (long)result.size());
        query = parser.parse("Lucene");
        result = fullTextSession.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"there should be match", (long)1L, (long)result.size());
        query = parser.parse("<NULL>");
        result = fullTextSession.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"there should be match", (long)1L, (long)result.size());
        result = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]).list();
        Assert.assertEquals((String)"there should be match", (long)2L, (long)result.size());
        transaction.commit();
        fullTextSession.clear();
    }

    private void persistBook(Session session, Book book) throws IOException {
        Transaction tx = session.beginTransaction();
        session.save((Object)book);
        session.flush();
        tx.commit();
        session.clear();
    }

    void indexBook(Session session) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        fullTextSession.setFlushMode(FlushMode.MANUAL);
        fullTextSession.setCacheMode(CacheMode.IGNORE);
        Transaction transaction = fullTextSession.beginTransaction();
        int BATCH_SIZE = 10;
        ScrollableResults results = fullTextSession.createCriteria(Book.class).setFetchSize(BATCH_SIZE).scroll(ScrollMode.FORWARD_ONLY);
        int index = 0;
        while (results.next()) {
            fullTextSession.index(results.get(0));
            if (++index % BATCH_SIZE != 0) continue;
            fullTextSession.flushToIndexes();
            fullTextSession.clear();
        }
        fullTextSession.flush();
        transaction.commit();
        fullTextSession.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        super.configure(cfg);
        cfg.put("hibernate.search.indexing_strategy", "manual");
    }

    private Blob dataAsBlob(File file, Session session) throws IOException {
        FileInputStream in = FileUtils.openInputStream((File)file);
        return session.getLobHelper().createBlob((InputStream)in, file.length());
    }

    private byte[] dataAsBytes(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    static {
        try {
            File pdfFile = new File(TikaBridgeInputTypeTest.class.getResource(TEST_DOCUMENT_PDF_1).toURI());
            PATH_TO_TEST_DOCUMENT_PDF_1 = pdfFile.getAbsolutePath();
            pdfFile = new File(TikaBridgeInputTypeTest.class.getResource(TEST_DOCUMENT_PDF_2).toURI());
            PATH_TO_TEST_DOCUMENT_PDF_2 = pdfFile.getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to determine file path for test document", e);
        }
    }
}

