/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.Session;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.util.impl.FileHelper;
import org.junit.Assert;
import org.junit.Test;

public class FSDirectoryTest
extends SearchTestBase {
    @Test
    public void testEventIntegration() throws Exception {
        try (Session s = this.getSessionFactory().openSession();){
            s.getTransaction().begin();
            s.persist((Object)new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
            s.getTransaction().commit();
        }
        try (FSDirectory dir = FSDirectory.open((Path)this.getBaseIndexDir().resolve("Documents"));){
            Document entity;
            try (DirectoryReader reader = DirectoryReader.open((Directory)dir);){
                int num = reader.numDocs();
                Assert.assertEquals((long)1L, (long)num);
                Assert.assertEquals((long)1L, (long)reader.docFreq(new Term("Abstract", "hibernate")));
                Assert.assertEquals((long)1L, (long)reader.docFreq(new Term("title", "action")));
                Assert.assertEquals((Object)"1", (Object)this.projectSingleField((IndexReader)reader, "id", new Term("title", "action")));
            }
            var5_13 = null;
            try (Session s = this.getSessionFactory().openSession();){
                s.getTransaction().begin();
                entity = (Document)s.get(Document.class, (Serializable)Long.valueOf(1L));
                entity.setSummary("Object/relational mapping with EJB3");
                s.persist((Object)new Document("Seam in Action", "", "blah blah blah blah"));
                s.getTransaction().commit();
            }
            catch (Throwable num) {
                var5_13 = num;
                throw num;
            }
            reader = DirectoryReader.open((Directory)dir);
            var5_13 = null;
            try {
                int num = reader.numDocs();
                Assert.assertEquals((long)2L, (long)num);
                Assert.assertEquals((long)1L, (long)reader.docFreq(new Term("Abstract", "ejb")));
            }
            catch (Throwable num) {
                var5_13 = num;
                throw num;
            }
            finally {
                if (reader != null) {
                    if (var5_13 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable num) {
                            var5_13.addSuppressed(num);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            s = this.getSessionFactory().openSession();
            var5_13 = null;
            try {
                s.getTransaction().begin();
                s.delete((Object)entity);
                s.getTransaction().commit();
            }
            catch (Throwable num) {
                var5_13 = num;
                throw num;
            }
            finally {
                if (s != null) {
                    if (var5_13 != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable num) {
                            var5_13.addSuppressed(num);
                        }
                    } else {
                        s.close();
                    }
                }
            }
            reader = DirectoryReader.open((Directory)dir);
            var5_13 = null;
            try {
                int num = reader.numDocs();
                Assert.assertEquals((long)1L, (long)num);
                Assert.assertEquals((long)1L, (long)reader.docFreq(new Term("title", "seam")));
                Assert.assertEquals((Object)"2", (Object)this.projectSingleField((IndexReader)reader, "id", new Term("title", "seam")));
            }
            catch (Throwable throwable) {
                var5_13 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var5_13 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var5_13.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        var3_5 = null;
        try (Session s = this.getSessionFactory().openSession();){
            s.getTransaction().begin();
            s.delete(s.createCriteria(Document.class).uniqueResult());
            s.getTransaction().commit();
        }
        catch (Throwable throwable) {
            var3_5 = throwable;
            throw throwable;
        }
    }

    private String projectSingleField(IndexReader reader, String fieldName, Term term) throws IOException {
        String projection = null;
        for (LeafReaderContext leaf : reader.leaves()) {
            LeafReader atomicReader = leaf.reader();
            DocsEnum termDocsEnum = atomicReader.termDocsEnum(term);
            while (termDocsEnum.nextDoc() != Integer.MAX_VALUE) {
                int docID = termDocsEnum.docID();
                org.apache.lucene.document.Document document = reader.document(docID);
                String value = document.get(fieldName);
                Assert.assertNull((String)"duplicate matches found! This method assumes a single document will match the Term.", projection);
                projection = value;
            }
        }
        Assert.assertNotNull(projection);
        return projection;
    }

    @Test
    public void testBoost() throws Exception {
        try (Session s = this.getSessionFactory().openSession();){
            s.getTransaction().begin();
            s.persist((Object)new Document("Hibernate in Action", "Object and Relational", "blah blah blah"));
            s.persist((Object)new Document("Object and Relational", "Hibernate in Action", "blah blah blah"));
            s.getTransaction().commit();
        }
        var2_2 = null;
        try (FSDirectory dir = FSDirectory.open((Path)this.getBaseIndexDir().resolve("Documents"));){
            DirectoryReader indexReader = DirectoryReader.open((Directory)dir);
            Object object = null;
            try {
                IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
                QueryParser qp = new QueryParser("id", TestConstants.standardAnalyzer);
                Query query = qp.parse("title:Action OR Abstract:Action");
                TopDocs hits = searcher.search(query, 1000);
                Assert.assertEquals((long)2L, (long)hits.totalHits);
                Assert.assertTrue((hits.scoreDocs[0].score == 2.0f * hits.scoreDocs[1].score ? 1 : 0) != 0);
                org.apache.lucene.document.Document doc = searcher.doc(0);
                Assert.assertEquals((Object)"Hibernate in Action", (Object)doc.get("title"));
            }
            catch (Throwable searcher) {
                object = searcher;
                throw searcher;
            }
            finally {
                if (indexReader != null) {
                    if (object != null) {
                        try {
                            indexReader.close();
                        }
                        catch (Throwable searcher) {
                            ((Throwable)object).addSuppressed(searcher);
                        }
                    } else {
                        indexReader.close();
                    }
                }
            }
        }
        catch (Throwable indexReader) {
            var2_2 = indexReader;
            throw indexReader;
        }
        s = this.getSessionFactory().openSession();
        var2_2 = null;
        try {
            s.getTransaction().begin();
            List list = s.createQuery("from Document").list();
            for (Document document : list) {
                s.delete((Object)document);
            }
            s.getTransaction().commit();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var2_2 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
    }

    @Test
    public void testSearchOnDeletedIndex() throws Exception {
        try (Session s = this.getSessionFactory().openSession();){
            s.getTransaction().begin();
            s.persist((Object)new Document("Hibernate Search in Action", "", ""));
            s.getTransaction().commit();
        }
        var2_2 = null;
        try (FSDirectory dir = FSDirectory.open((Path)this.getBaseIndexDir().resolve("Documents"));
             DirectoryReader indexReader = DirectoryReader.open((Directory)dir);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
            FileHelper.tryDelete((Path)this.getBaseIndexDir());
            TermQuery query = new TermQuery(new Term("title", "action"));
            TopDocs hits = searcher.search((Query)query, 1000);
            Assert.assertEquals((long)1L, (long)hits.totalHits);
            org.apache.lucene.document.Document doc = searcher.doc(0);
            Assert.assertEquals((Object)"Hibernate Search in Action", (Object)doc.get("title"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.directory_provider", "filesystem");
    }
}

