/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.depth;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.depth.SocialPerson;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.backend.LeakingLuceneBackend;
import org.junit.Assert;
import org.junit.Test;

public class RecursiveGraphIncludePathsTest
extends SearchTestBase {
    @Test
    @TestForIssue(jiraKey="HSEARCH-2074")
    public void testCorrectDepthIndexedWithIncludePath() {
        this.prepareSocialGraph();
        this.verifyMatchExistsWithName("name", "Ross", 0L);
        this.verifyMatchExistsWithName("name", "Rachel", 5L);
        this.verifyMatchExistsWithName("name", "Gunter", 6L);
        this.verifyMatchExistsWithName("friends.name", "Ross", 1L, 2L, 3L, 4L, 5L);
        this.verifyMatchExistsWithName("friends.name", "Rachel", 0L, 1L, 2L, 3L, 4L, 6L);
        this.verifyNoMatchExists("friends.name", "Gunter");
        LeakingLuceneBackend.reset();
        this.renamePerson(5L, "Rachelita");
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(0L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(1L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(2L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(3L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(4L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(5L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(6L));
        LeakingLuceneBackend.reset();
        this.renamePerson(0L, "Rossito");
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(0L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(1L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(2L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(3L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(4L));
        Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(5L));
        Assert.assertEquals((long)0L, (long)this.countWorksDoneOnPerson(6L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renamePerson(Long id, String newName) {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction transaction = fullTextSession.beginTransaction();
            SocialPerson person = (SocialPerson)fullTextSession.load(SocialPerson.class, (Serializable)id);
            person.setName(newName);
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyNoMatchExists(String fieldName, String fieldValue) {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term(fieldName, fieldValue));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            Assert.assertEquals((long)0L, (long)resultSize);
            List list = fullTextQuery.list();
            Assert.assertEquals((long)0L, (long)list.size());
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyMatchExistsWithName(String fieldName, String fieldValue, Long ... expectedIds) {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term(fieldName, fieldValue));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            Assert.assertEquals((long)expectedIds.length, (long)resultSize);
            List list = fullTextQuery.list();
            Assert.assertEquals((long)expectedIds.length, (long)list.size());
            List<Long> expectIdsList = Arrays.asList(expectedIds);
            for (SocialPerson person : list) {
                Assert.assertTrue((boolean)expectIdsList.contains(person.getId()));
            }
            transaction.commit();
        }
    }

    private void prepareSocialGraph() {
        int i;
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        SocialPerson[] ps = new SocialPerson[]{new SocialPerson(0L, "Ross"), new SocialPerson(1L, "Chandler"), new SocialPerson(2L, "Joey"), new SocialPerson(3L, "Phoebe"), new SocialPerson(4L, "Monica"), new SocialPerson(5L, "Rachel"), new SocialPerson(6L, "Gunter")};
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (i == j) continue;
                ps[i].addFriends(ps[j]);
            }
        }
        ps[6].addFriends(ps[5]);
        for (i = 0; i < ps.length; ++i) {
            session.save((Object)ps[i]);
        }
        transaction.commit();
        session.close();
        for (i = 1; i < ps.length; ++i) {
            Assert.assertEquals((long)1L, (long)this.countWorksDoneOnPerson(Long.valueOf(i)));
        }
    }

    private int countWorksDoneOnPerson(Long pk) {
        List processedQueue = LeakingLuceneBackend.getLastProcessedQueue();
        int count = 0;
        for (LuceneWork luceneWork : processedQueue) {
            Serializable id = luceneWork.getId();
            if (!pk.equals(id)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{SocialPerson.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.worker.backend", LeakingLuceneBackend.class.getName());
    }
}

