/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.sorting;

import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.test.query.sorting.BrickLayer;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SortTest
extends SearchTestBase {
    private static FullTextSession fullTextSession;
    private static QueryParser queryParser;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        fullTextSession = Search.getFullTextSession((Session)this.openSession());
        queryParser = new QueryParser("title", TestConstants.stopAnalyzer);
        this.createTestBooks();
        this.createTestNumbers();
        this.createTestContractors();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (fullTextSession.getTransaction().getStatus() != TransactionStatus.ACTIVE) {
            this.deleteTestBooks();
            this.deleteTestNumbers();
            this.deleteTestContractors();
            fullTextSession.close();
        }
        super.tearDown();
    }

    @Test
    public void testResultOrderedByIdAsString() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField("id", SortField.Type.STRING, false));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assertions.assertThat((List)result).onProperty("id").containsExactly(new Object[]{1, 10, 2, 3});
        tx.commit();
    }

    @Test
    public void testResultOrderedByIdAsLong() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField("id_forIntegerSort", SortField.Type.INT, false));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assertions.assertThat((List)result).onProperty("id").containsExactly(new Object[]{1, 2, 3, 10});
        tx.commit();
    }

    @Test
    public void testResultOrderedByIdAlteringSortStyle() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        hibQuery.setSort(new Sort(new SortField("id", SortField.Type.STRING, false)));
        List result = hibQuery.list();
        Assertions.assertThat((List)result).onProperty("id").containsExactly(new Object[]{1, 10, 2, 3});
        hibQuery.setSort(new Sort(new SortField("id_forIntegerSort", SortField.Type.INT, false)));
        result = hibQuery.list();
        Assertions.assertThat((List)result).onProperty("id").containsExactly(new Object[]{1, 2, 3, 10});
        hibQuery.setSort(new Sort(new SortField("id", SortField.Type.STRING, false)));
        result = hibQuery.list();
        Assertions.assertThat((List)result).onProperty("id").containsExactly(new Object[]{1, 10, 2, 3});
        tx.commit();
    }

    @Test
    public void testResultOrderedBySummaryStringAscending() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene OR summary:action");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField("summary_forSort", SortField.Type.STRING));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Wrong number of test results.", (long)5L, (long)result.size());
        Assert.assertEquals((Object)"Groovy in Action", (Object)((Book)result.get(0)).getSummary());
        tx.commit();
    }

    @Test
    public void testResultOrderedBySummaryStringDescending() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene OR summary:action");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField("summary_forSort", SortField.Type.STRING, true));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Wrong number of test results.", (long)5L, (long)result.size());
        Assert.assertEquals((Object)"Hibernate & Lucene", (Object)((Book)result.get(0)).getSummary());
        tx.commit();
    }

    @Test
    public void testResultOrderedByDateDescending() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene OR summary:action");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField("publicationDate", SortField.Type.STRING, true));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assertions.assertThat((List)result).onProperty("id").containsExactly(new Object[]{4, 10, 3, 2, 1});
        Assert.assertEquals((Object)"Groovy in Action", (Object)((Book)result.get(0)).getSummary());
        tx.commit();
    }

    @Test
    public void testCustomFieldComparatorAscendingSort() {
        Transaction tx = fullTextSession.beginTransaction();
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{NumberHolder.class});
        Sort sort = new Sort(new SortField("sum", (FieldComparatorSource)new SumFieldComparatorSource()));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Wrong number of test results.", (long)4L, (long)result.size());
        int previousSum = 0;
        for (NumberHolder n : result) {
            Assert.assertTrue((String)"Documents should be ordered by increasing sum", (previousSum < n.getSum() ? 1 : 0) != 0);
            previousSum = n.getSum();
        }
        tx.commit();
    }

    @Test
    public void testCustomFieldComparatorDescendingSort() {
        Transaction tx = fullTextSession.beginTransaction();
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{NumberHolder.class});
        Sort sort = new Sort(new SortField("sum", (FieldComparatorSource)new SumFieldComparatorSource(), true));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Wrong number of test results.", (long)4L, (long)result.size());
        int previousSum = 100;
        for (NumberHolder n : result) {
            Assert.assertTrue((String)"Documents should be ordered by decreasing sum", (previousSum > n.getSum() ? 1 : 0) != 0);
            previousSum = n.getSum();
        }
        tx.commit();
    }

    @Test
    public void testResultOrderedByDocId() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField(null, SortField.Type.DOC, false));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assertions.assertThat((List)result).onProperty("id").containsOnly(new Object[]{1, 2, 3, 10});
        tx.commit();
    }

    @Test
    public void testResultOrderedByEmbeddedAuthorNameAscending() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene OR summary:action");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField("mainAuthor.name", SortField.Type.STRING));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assertions.assertThat((List)result).onProperty("id").containsExactly(new Object[]{2, 1, 3, 4, 10});
        tx.commit();
    }

    @Test
    public void testSortingByMultipleFields() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("name:Bill OR name:Barny OR name:Bart");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{BrickLayer.class});
        Sort sort = new Sort(new SortField[]{new SortField("sortLastName", SortField.Type.STRING), new SortField("sortName", SortField.Type.STRING)});
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assertions.assertThat((List)result).onProperty("lastName").containsExactly(new Object[]{"Higgins", "Higgins", "Johnson", "Johnson"});
        Assertions.assertThat((List)result).onProperty("name").containsExactly(new Object[]{"Barny the brick layer", "Bart the brick layer", "Barny the brick layer", "Bill the brick layer"});
        tx.commit();
    }

    private void createTestBooks() {
        Transaction tx = fullTextSession.beginTransaction();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        cal.set(2007, 6, 25, 11, 20, 30);
        Author author = new Author("Bob");
        fullTextSession.save((Object)author);
        Book book = new Book(1, "Hibernate & Lucene", "This is a test book.");
        book.setPublicationDate(cal.getTime());
        book.setMainAuthor(author);
        fullTextSession.save((Object)book);
        author = new Author("Anthony");
        fullTextSession.save((Object)author);
        cal.add(13, 1);
        book = new Book(2, "Hibernate & Lucene", "This is a test book.");
        book.setMainAuthor(author);
        book.setPublicationDate(cal.getTime());
        fullTextSession.save((Object)book);
        author = new Author("Calvin");
        fullTextSession.save((Object)author);
        cal.add(13, 1);
        book = new Book(3, "Hibernate & Lucene", "This is a test book.");
        book.setMainAuthor(author);
        book.setPublicationDate(cal.getTime());
        fullTextSession.save((Object)book);
        author = new Author("Ernst");
        fullTextSession.save((Object)author);
        cal.add(13, 1);
        book = new Book(10, "Hibernate & Lucene", "This is a test book.");
        book.setMainAuthor(author);
        book.setPublicationDate(cal.getTime());
        fullTextSession.save((Object)book);
        author = new Author("Dennis");
        fullTextSession.save((Object)author);
        cal.add(13, 1);
        book = new Book(4, "Groovy in Action", "The bible of Groovy");
        book.setMainAuthor(author);
        book.setPublicationDate(cal.getTime());
        fullTextSession.save((Object)book);
        tx.commit();
        fullTextSession.clear();
    }

    private void createTestNumbers() {
        Transaction tx = fullTextSession.beginTransaction();
        NumberHolder holder = new NumberHolder(1, 1);
        fullTextSession.save((Object)holder);
        holder = new NumberHolder(1, 10);
        fullTextSession.save((Object)holder);
        holder = new NumberHolder(1, 5);
        fullTextSession.save((Object)holder);
        holder = new NumberHolder(3, 2);
        fullTextSession.save((Object)holder);
        tx.commit();
        fullTextSession.clear();
    }

    private void createTestContractors() {
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)new BrickLayer(2, "Bill the brick layer", "Johnson"));
        fullTextSession.save((Object)new BrickLayer(4, "Barny the brick layer", "Johnson"));
        fullTextSession.save((Object)new BrickLayer(5, "Bart the brick layer", "Higgins"));
        fullTextSession.save((Object)new BrickLayer(6, "Barny the brick layer", "Higgins"));
        tx.commit();
        fullTextSession.clear();
    }

    private void deleteTestBooks() {
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.createQuery("delete " + Book.class.getName()).executeUpdate();
        tx.commit();
        fullTextSession.clear();
    }

    private void deleteTestNumbers() {
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.createQuery("delete " + NumberHolder.class.getName()).executeUpdate();
        tx.commit();
        fullTextSession.clear();
    }

    private void deleteTestContractors() {
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.createQuery("delete " + BrickLayer.class.getName()).executeUpdate();
        tx.commit();
        fullTextSession.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Author.class, NumberHolder.class, BrickLayer.class};
    }

    public static class SumFieldComparator
    extends SimpleFieldComparator<Integer> {
        private final String field1;
        private final String field2;
        private final int[] field1Values;
        private final int[] field2Values;
        private NumericDocValues currentReaderValuesField1;
        private NumericDocValues currentReaderValuesField2;
        private int bottom;
        private Integer topValue;

        public SumFieldComparator(int numHits, String field1, String field2) {
            this.field1 = field1;
            this.field2 = field2;
            this.field1Values = new int[numHits];
            this.field2Values = new int[numHits];
        }

        public int compare(int slot1, int slot2) {
            int v1 = this.field1Values[slot1] + this.field2Values[slot1];
            int v2 = this.field1Values[slot2] + this.field2Values[slot2];
            return this.compareValues(v1, v2);
        }

        private int compareValues(int v1, int v2) {
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        public int compareBottom(int doc) {
            int v = (int)(this.currentReaderValuesField1.get(doc) + this.currentReaderValuesField2.get(doc));
            return this.compareValues(this.bottom, v);
        }

        public int compareTop(int doc) throws IOException {
            return this.topValue - this.field1Values[doc] - this.field2Values[doc];
        }

        public void copy(int slot, int doc) {
            int v2;
            int v1;
            this.field1Values[slot] = v1 = (int)this.currentReaderValuesField1.get(doc);
            this.field2Values[slot] = v2 = (int)this.currentReaderValuesField2.get(doc);
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            LeafReader reader = context.reader();
            this.currentReaderValuesField1 = reader.getNumericDocValues(this.field1);
            this.currentReaderValuesField2 = reader.getNumericDocValues(this.field2);
        }

        public void setBottom(int bottom) {
            this.bottom = this.field1Values[bottom] + this.field2Values[bottom];
        }

        public void setTopValue(Integer value) {
            this.topValue = value;
        }

        public Integer value(int slot) {
            return this.field1Values[slot] + this.field2Values[slot];
        }
    }

    public static class SumFieldComparatorSource
    extends FieldComparatorSource {
        public FieldComparator<?> newComparator(String fieldName, int numHits, int sortPos, boolean reversed) throws IOException {
            return new SumFieldComparator(numHits, "num1", "num2");
        }
    }

    public static class SortFieldCreatingClassBridge
    implements MetadataProvidingFieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            NumberHolder numberHolder = (NumberHolder)value;
            document.add((IndexableField)new NumericDocValuesField("num1", (long)numberHolder.num1));
            document.add((IndexableField)new NumericDocValuesField("num2", (long)numberHolder.num2));
        }

        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field("sum", FieldType.INTEGER).sortable(true);
        }
    }

    @Entity
    @Indexed
    @ClassBridge(impl=SortFieldCreatingClassBridge.class)
    public static class NumberHolder {
        @Id
        @GeneratedValue
        int id;
        @Field(analyze=Analyze.NO)
        int num1;
        @Field(analyze=Analyze.NO)
        int num2;

        public NumberHolder(int num1, int num2) {
            this.num1 = num1;
            this.num2 = num2;
        }

        public NumberHolder() {
        }

        public int getSum() {
            return this.num1 + this.num2;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("NumbersHolder");
            sb.append("{id=").append(this.id);
            sb.append(", num1=").append(this.num1);
            sb.append(", num2=").append(this.num2);
            sb.append('}');
            return sb.toString();
        }
    }
}

