/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.optimizations;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import org.hibernate.Transaction;
import org.hibernate.collection.internal.PersistentBag;
import org.hibernate.collection.internal.PersistentSet;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.IndexedMapping;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.test.engine.optimizations.Catalog;
import org.hibernate.search.test.engine.optimizations.CatalogItem;
import org.hibernate.search.test.engine.optimizations.Consumer;
import org.hibernate.search.test.engine.optimizations.Item;
import org.hibernate.search.test.engine.optimizations.NoopClassBridge;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-679")
public class CollectionUpdateEventTest {
    private static boolean WITH_CLASS_BRIDGE_ON_ITEM = true;
    private static boolean WITHOUT_CLASS_BRIDGE_ON_ITEM = false;
    private static boolean WITH_CLASS_BRIDGE_ON_CATALOG = true;
    private static boolean WITHOUT_CLASS_BRIDGE_ON_CATALOG = false;

    @Test
    public void testWithClassBridge() {
        this.testScenario(WITH_CLASS_BRIDGE_ON_ITEM, 2, WITHOUT_CLASS_BRIDGE_ON_CATALOG);
    }

    @Test
    public void testWithoutClassBridge() {
        this.testScenario(WITHOUT_CLASS_BRIDGE_ON_ITEM, 2, WITHOUT_CLASS_BRIDGE_ON_CATALOG);
    }

    @Test
    public void testWithNoEnoughDepth() {
        this.testScenario(WITH_CLASS_BRIDGE_ON_ITEM, 1, WITHOUT_CLASS_BRIDGE_ON_CATALOG);
    }

    @Test
    public void testWithDeepClassBridge() {
        this.testScenario(WITHOUT_CLASS_BRIDGE_ON_ITEM, 1, WITH_CLASS_BRIDGE_ON_CATALOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScenario(boolean withClassBridgeOnItem, int depth, boolean withClassBridgeOnCatalog) {
        try (FullTextSessionBuilder fulltextSessionBuilder = this.configure(withClassBridgeOnItem, depth, withClassBridgeOnCatalog);){
            this.initializeData(fulltextSessionBuilder);
            try (FullTextSession fullTextSession = fulltextSessionBuilder.openFullTextSession();){
                Catalog catalog = (Catalog)fullTextSession.get(Catalog.class, (Serializable)Long.valueOf(1L));
                PersistentSet catalogItems = (PersistentSet)catalog.getCatalogItems();
                PersistentBag consumers = (PersistentBag)catalog.getConsumers();
                Assert.assertFalse((String)"consumers should not be initialized", (boolean)consumers.wasInitialized());
                Assert.assertFalse((String)"catalogItems should not be initialized", (boolean)consumers.wasInitialized());
                this.updateCatalogsCollection(fullTextSession, catalog);
                if ((withClassBridgeOnItem || withClassBridgeOnCatalog) && depth > 1) {
                    Assert.assertTrue((String)"catalogItems should have been initialized", (boolean)catalogItems.wasInitialized());
                } else {
                    Assert.assertFalse((String)"catalogItems should not be initialized", (boolean)catalogItems.wasInitialized());
                }
            }
        }
    }

    private FullTextSessionBuilder configure(boolean withClassBridgeOnItem, int depth, boolean withClassBridgeOnCatalog) {
        FullTextSessionBuilder builder = new FullTextSessionBuilder().addAnnotatedClass(Catalog.class).addAnnotatedClass(CatalogItem.class).addAnnotatedClass(Consumer.class).addAnnotatedClass(Item.class);
        SearchMapping fluentMapping = builder.fluentMapping();
        EntityMapping catalogMapping = fluentMapping.entity(Catalog.class);
        if (withClassBridgeOnCatalog) {
            catalogMapping.classBridge(NoopClassBridge.class);
        }
        catalogMapping.property("catalogItems", ElementType.FIELD).containedIn();
        fluentMapping.entity(CatalogItem.class).property("item", ElementType.FIELD).containedIn().property("catalog", ElementType.FIELD).indexEmbedded();
        IndexedMapping itemMapping = fluentMapping.entity(Item.class).indexed();
        if (withClassBridgeOnItem) {
            itemMapping.classBridge(NoopClassBridge.class);
        }
        itemMapping.property("catalogItems", ElementType.FIELD).indexEmbedded().depth(depth);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeData(FullTextSessionBuilder fulltextSessionBuilder) {
        try (FullTextSession fullTextSession = fulltextSessionBuilder.openFullTextSession();){
            Transaction transaction = fullTextSession.beginTransaction();
            Catalog catalog = new Catalog();
            catalog.setCatalogId(1L);
            catalog.setName("parts");
            fullTextSession.persist((Object)catalog);
            for (int i = 0; i < 5; ++i) {
                Item item = new Item();
                item.setName("battery");
                fullTextSession.persist((Object)item);
                CatalogItem catalogItem = new CatalogItem();
                catalogItem.setCatalog(catalog);
                catalogItem.setItem(item);
                fullTextSession.persist((Object)catalogItem);
                item.getCatalogItems().add(catalogItem);
                fullTextSession.merge((Object)item);
                catalog.getCatalogItems().add(catalogItem);
                fullTextSession.merge((Object)catalog);
            }
            transaction.commit();
        }
    }

    private void updateCatalogsCollection(FullTextSession fullTextSession, Catalog catalog) {
        Transaction transaction = fullTextSession.beginTransaction();
        Consumer consumer = new Consumer();
        consumer.setName("consumer");
        consumer.getCatalogs().add(catalog);
        fullTextSession.persist((Object)consumer);
        catalog.getConsumers().add(consumer);
        fullTextSession.merge((Object)catalog);
        transaction.commit();
    }
}

