/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.interceptor;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-642")
public class ManualIndexingOnlyInterceptorTest
extends SearchTestBase {
    private FullTextSession fullTextSession;
    private List<Foo> testEntities;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.createTestData();
    }

    @Test
    public void testAutomaticIndexUpdatesAreProhibitedByInterceptor() throws Exception {
        this.indexTestData();
        FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
        Assert.assertEquals((String)"There should be no indexed entities, since automatic indexing is disabled via interceptor", (long)0L, (long)fullTextQuery.list().size());
    }

    @Test
    public void testExplicitIndexingIgnoresInterceptor() throws Exception {
        this.indexTestData();
        Transaction tx = this.fullTextSession.beginTransaction();
        for (Foo foo : this.testEntities) {
            Foo attachedFoo = (Foo)this.fullTextSession.merge((Object)foo);
            this.fullTextSession.index((Object)attachedFoo);
        }
        tx.commit();
        FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
        Assert.assertEquals((String)"All test entities should be indexed", (long)this.testEntities.size(), (long)fullTextQuery.list().size());
    }

    @Test
    public void testIndexUpdatesViaMassIndexerProhibitedByInterceptor() throws Exception {
        this.indexTestData();
        MassIndexer massIndexer = this.fullTextSession.createIndexer(new Class[0]);
        massIndexer.startAndWait();
        FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
        Assert.assertEquals((String)"There should be no indexed entities, since interceptor also applied for mass indexer", (long)0L, (long)fullTextQuery.list().size());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Foo.class};
    }

    private void createTestData() {
        this.testEntities = new ArrayList<Foo>();
        for (int i = 0; i < 3; ++i) {
            this.testEntities.add(new Foo());
        }
    }

    private void indexTestData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        for (Foo foo : this.testEntities) {
            this.fullTextSession.save((Object)foo);
        }
        tx.commit();
        this.fullTextSession.clear();
    }

    public static class ManualIndexingOnly
    implements EntityIndexingInterceptor {
        public IndexingOverride onAdd(Object entity) {
            return IndexingOverride.SKIP;
        }

        public IndexingOverride onUpdate(Object entity) {
            return IndexingOverride.SKIP;
        }

        public IndexingOverride onDelete(Object entity) {
            return IndexingOverride.APPLY_DEFAULT;
        }

        public IndexingOverride onCollectionUpdate(Object entity) {
            return this.onUpdate(entity);
        }
    }

    @Entity
    @Indexed(interceptor=ManualIndexingOnly.class)
    public static class Foo {
        @Id
        @GeneratedValue
        private long id;
    }
}

