/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.spatial.Coordinates;

@Entity
@Spatial(spatialMode=SpatialMode.HASH, name="location")
@Indexed(index="ProductArticle")
public class ProductArticle
implements Coordinates {
    @Id
    @Basic(optional=false)
    @Column(name="article_id")
    private Integer articleId;
    @Column(name="header")
    @Field(index=Index.YES, store=Store.YES)
    private String header;
    @Column(name="latitude")
    private Double latitude;
    @Column(name="longitude")
    private Double longitude;
    @SortableField
    @Column(name="creation_date")
    @Field(analyze=Analyze.NO)
    @DateBridge(resolution=Resolution.DAY)
    private Date creationDate;

    public Integer getArticleId() {
        return this.articleId;
    }

    public void setArticleId(Integer articleId) {
        this.articleId = articleId;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String toString() {
        return "[" + this.articleId + ", " + this.header + ", " + this.creationDate + "]";
    }
}

