/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.ElectricalProperties;
import org.hibernate.search.test.query.Employee;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class TermVectorTest
extends SearchTestBase {
    @Test
    public void testPositionOffsets() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.createIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        SearchFactory searchFactory = s.getSearchFactory();
        IndexReader reader = searchFactory.getIndexReaderAccessor().open(new Class[]{ElectricalProperties.class});
        int x = 0;
        Terms termVector = reader.getTermVector(x, "content");
        Assert.assertNotNull((Object)termVector);
        TermsEnum iterator = termVector.iterator();
        BytesRef next = iterator.next();
        Assert.assertNotNull((Object)next);
        long totalTermFreq = iterator.totalTermFreq();
        Assert.assertEquals((Object)"electrical", (Object)next.utf8ToString());
        Assert.assertEquals((long)2L, (long)totalTermFreq);
        DocsAndPositionsEnum docsAndPositions = iterator.docsAndPositions(null, null);
        docsAndPositions.advance(0);
        docsAndPositions.nextPosition();
        Assert.assertEquals((long)0L, (long)docsAndPositions.startOffset());
        Assert.assertEquals((long)10L, (long)docsAndPositions.endOffset());
        docsAndPositions.nextPosition();
        Assert.assertEquals((long)29L, (long)docsAndPositions.startOffset());
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        searchFactory.getIndexReaderAccessor().close(reader);
        tx.commit();
        s.close();
    }

    @Test
    public void testNoTermVector() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Employee e1 = new Employee(1000, "Griffin", "ITech");
        s.save((Object)e1);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        SearchFactory searchFactory = s.getSearchFactory();
        IndexReader reader = searchFactory.getIndexReaderAccessor().open(new Class[]{Employee.class});
        Terms termVector = reader.getTermVector(0, "dept");
        Assert.assertNull((String)"should not find a term position vector", (Object)termVector);
        for (Object element : s.createQuery("from " + ElectricalProperties.class.getName()).list()) {
            s.delete(element);
        }
        searchFactory.getIndexReaderAccessor().close(reader);
        tx.commit();
        s.close();
    }

    private void createIndex(FullTextSession s) {
        this.storeSeparately(s, new ElectricalProperties(1000, "Electrical Engineers measure Electrical Properties"));
        this.storeSeparately(s, new ElectricalProperties(1001, "Electrical Properties are interesting"));
        this.storeSeparately(s, new ElectricalProperties(1002, "Electrical Properties are measurable properties"));
    }

    private void storeSeparately(FullTextSession s, ElectricalProperties ep) {
        Transaction tx = s.beginTransaction();
        s.save((Object)ep);
        tx.commit();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{ElectricalProperties.class, Employee.class};
    }
}

