/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl.embedded;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.dsl.embedded.ContainerEntity;
import org.hibernate.search.test.query.dsl.embedded.EmbeddedEntity;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DslEmbeddedSearchTest
extends SearchTestBase {
    private Session s = null;

    private static Calendar initCalendar(int year, int month, int day) {
        Calendar instance = DslEmbeddedSearchTest.createCalendar();
        instance = DateUtils.truncate((Calendar)instance, (int)5);
        instance.set(year, month, day);
        return instance;
    }

    private static Calendar createCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("Europe/Rome"), Locale.ITALY);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        EmbeddedEntity ee = new EmbeddedEntity();
        ee.setEmbeddedField("embedded");
        ee.setNumber(7);
        ee.setDate(DslEmbeddedSearchTest.initCalendar(2007, 0, 14).getTime());
        ContainerEntity pe = new ContainerEntity();
        pe.setEmbeddedEntity(ee);
        pe.setParentStringValue("theparentvalue");
        this.s = this.openSession();
        this.s.getTransaction().begin();
        this.s.persist((Object)pe);
        this.s.getTransaction().commit();
        EmbeddedEntity ee2 = new EmbeddedEntity();
        ee2.setEmbeddedField("otherembedded");
        ee2.setNumber(3);
        ee2.setDate(DslEmbeddedSearchTest.initCalendar(2007, 0, 12).getTime());
        ContainerEntity pe2 = new ContainerEntity();
        pe2.setEmbeddedEntity(ee2);
        pe2.setParentStringValue("theotherparentvalue");
        this.s.getTransaction().begin();
        this.s.persist((Object)pe2);
        this.s.getTransaction().commit();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.s != null) {
            this.s.clear();
            this.deleteAll(this.s, ContainerEntity.class);
            this.s.close();
        }
        super.tearDown();
    }

    @Test
    public void testSearchString() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.s);
        QueryBuilder qb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ContainerEntity.class).get();
        Query q = qb.keyword().onField("emb.embeddedField").matching((Object)"embedded").createQuery();
        List<ContainerEntity> results = this.execute(fullTextSession, q);
        Assert.assertEquals((String)"DSL didn't find the embedded string field", (long)1L, (long)results.size());
        Assert.assertEquals((Object)"embedded", (Object)results.get(0).getEmbeddedEntity().getEmbeddedField());
    }

    @Test
    public void testSearchNumberWithFieldBridge() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.s);
        QueryBuilder qb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ContainerEntity.class).get();
        Query q = qb.keyword().onField("emb.num").matching((Object)7).createQuery();
        List<ContainerEntity> results = this.execute(fullTextSession, q);
        Assert.assertEquals((String)"DSL didn't find the embedded numeric field", (long)1L, (long)results.size());
        Assert.assertEquals((Object)7, (Object)results.get(0).getEmbeddedEntity().getNumber());
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2070")
    public void testSearchDateWithoutFieldBridge() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.s);
        QueryBuilder qb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ContainerEntity.class).get();
        Query q = qb.range().onField("emb.date").above((Object)DslEmbeddedSearchTest.initCalendar(2007, 0, 14).getTime()).createQuery();
        List<ContainerEntity> results = this.execute(fullTextSession, q);
        Assert.assertEquals((String)"DSL didn't find the embedded date field.", (long)1L, (long)results.size());
        Assert.assertEquals((Object)DslEmbeddedSearchTest.initCalendar(2007, 0, 14).getTime(), (Object)results.get(0).getEmbeddedEntity().getDate());
    }

    private List<ContainerEntity> execute(FullTextSession fullTextSession, Query q) {
        FullTextQuery combinedQuery = fullTextSession.createFullTextQuery(q, new Class[]{ContainerEntity.class});
        return combinedQuery.list();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{ContainerEntity.class};
    }

    private void deleteAll(Session s, Class<?> ... classes) {
        Transaction tx = s.beginTransaction();
        for (Class<?> each : classes) {
            List list = s.createCriteria(each).list();
            for (Object object : list) {
                s.delete(object);
            }
        }
        tx.commit();
    }
}

