/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.filter.impl.CachingWrapperFilter;

public class FieldConstraintFilterFactoryWithoutKeyMethod {
    private static List<BuildFilterInvocation> builtFilters = new ArrayList<BuildFilterInvocation>();
    private String field;
    private String value;

    @Factory
    public Filter buildFilter() {
        builtFilters.add(new BuildFilterInvocation(this.field, this.value));
        TermQuery q = new TermQuery(new Term(this.field, this.value));
        QueryWrapperFilter filter = new QueryWrapperFilter((Query)q);
        filter = new CachingWrapperFilter((Filter)filter);
        return filter;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setValue(String value) {
        this.value = value;
    }

    static List<BuildFilterInvocation> getBuiltFilters() {
        return builtFilters;
    }

    static class BuildFilterInvocation {
        private final String field;
        private final String value;

        public BuildFilterInvocation(String field, String value) {
            this.field = field;
            this.value = value;
        }

        public String getField() {
            return this.field;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BuildFilterInvocation other = (BuildFilterInvocation)obj;
            if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "BuildFilterInvocation [field=" + this.field + ", value=" + this.value + "]";
        }
    }
}

