/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.analyzer.AlarmEntity;
import org.hibernate.search.test.analyzer.MyEntity;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@TestForIssue(jiraKey="HSEARCH-263")
@Category(value={SkipOnElasticsearch.class})
public class DoubleAnalyzerTest
extends SearchTestBase {
    public static final Log log = LoggerFactory.make();

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{MyEntity.class, AlarmEntity.class};
    }

    @Test
    public void testScopedAnalyzers() throws Exception {
        MyEntity en = new MyEntity();
        en.setEntity("anyNotNull");
        AlarmEntity alarmEn = new AlarmEntity();
        alarmEn.setProperty("notNullAgain");
        alarmEn.setAlarmDescription("description");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)en);
        s.persist((Object)alarmEn);
        tx.commit();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        MatchAllDocsQuery luceneQuery = new MatchAllDocsQuery();
        FullTextQuery query = s.createFullTextQuery((Query)luceneQuery, new Class[0]);
        Assert.assertEquals((long)2L, (long)query.getResultSize());
        luceneQuery = parser.parse("entity:alarm");
        query = s.createFullTextQuery((Query)luceneQuery, new Class[]{MyEntity.class});
        Assert.assertEquals((long)1L, (long)query.getResultSize());
        luceneQuery = parser.parse("property:sound");
        query = s.createFullTextQuery((Query)luceneQuery, new Class[]{AlarmEntity.class});
        Assert.assertEquals((long)0L, (long)query.getResultSize());
        luceneQuery = parser.parse("description_analyzer2:sound");
        query = s.createFullTextQuery((Query)luceneQuery, new Class[]{AlarmEntity.class});
        Assert.assertEquals((long)1L, (long)query.getResultSize());
        luceneQuery = parser.parse("description_analyzer3:music");
        query = s.createFullTextQuery((Query)luceneQuery, new Class[]{AlarmEntity.class});
        Assert.assertEquals((long)1L, (long)query.getResultSize());
        tx.commit();
        s.close();
    }
}

