/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.MassIndexerImpl;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.batchindexing.AncientBook;
import org.hibernate.search.test.batchindexing.Book;
import org.hibernate.search.test.batchindexing.Dvd;
import org.hibernate.search.test.batchindexing.Nation;
import org.hibernate.search.test.batchindexing.SecretBook;
import org.hibernate.search.test.batchindexing.TitleAble;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.textbuilder.SentenceInventor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class IndexingGeneratedCorpusTest {
    private static final Log log = LoggerFactory.make();
    private static final int BOOK_NUM = 140;
    private static final int ANCIENTBOOK_NUM = 120;
    private static final int SECRETBOOK_NUM = 20;
    private static final int DVD_NUM = 200;
    private static final SentenceInventor sentenceInventor = new SentenceInventor(7L, 4000);
    @ClassRule
    public static FullTextSessionBuilder builder = new FullTextSessionBuilder().addAnnotatedClass(Book.class).addAnnotatedClass(Dvd.class).addAnnotatedClass(AncientBook.class).addAnnotatedClass(Nation.class).addAnnotatedClass(SecretBook.class).setProperty("hibernate.search.DVDS.exclusive_index_use", "false").setProperty("hibernate.search.default.worker.thread_pool.size", "4");

    @BeforeClass
    public static void setUp() throws Exception {
        IndexingGeneratedCorpusTest.createMany(Book.class, 140);
        IndexingGeneratedCorpusTest.createMany(Dvd.class, 200);
        IndexingGeneratedCorpusTest.createMany(AncientBook.class, 120);
        IndexingGeneratedCorpusTest.createMany(SecretBook.class, 20);
        IndexingGeneratedCorpusTest.storeAllBooksInNation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createMany(Class<? extends TitleAble> entityType, int amount) throws InstantiationException, IllegalAccessException {
        int totalEntitiesInDB = 0;
        try (FullTextSession fullTextSession = builder.openFullTextSession();){
            Transaction tx = fullTextSession.beginTransaction();
            fullTextSession.persist((Object)new Nation("Italy", "IT"));
            tx.commit();
            tx = fullTextSession.beginTransaction();
            for (int i = 0; i < amount; ++i) {
                TitleAble instance = entityType.newInstance();
                instance.setTitle(sentenceInventor.nextSentence());
                Nation country = (Nation)fullTextSession.load(Nation.class, (Serializable)Integer.valueOf(1));
                instance.setFirstPublishedIn(country);
                fullTextSession.persist((Object)instance);
                ++totalEntitiesInDB;
                if (i % 250 != 249) continue;
                tx.commit();
                fullTextSession.clear();
                System.out.println("Test preparation: " + totalEntitiesInDB + " entities persisted");
                tx = fullTextSession.beginTransaction();
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeAllBooksInNation() {
        try (FullTextSession fullTextSession = builder.openFullTextSession();){
            Transaction tx = fullTextSession.beginTransaction();
            List allBooks = fullTextSession.createCriteria(Book.class).list();
            Nation italy = (Nation)fullTextSession.load(Nation.class, (Serializable)Integer.valueOf(1));
            italy.getLibrariesHave().addAll(allBooks);
            tx.commit();
        }
    }

    @Test
    public void testBatchIndexing() throws InterruptedException, IOException {
        this.verifyResultNumbers();
        this.purgeAll();
        this.verifyIsEmpty();
        this.reindexAll();
        this.verifyResultNumbers();
        this.reindexAll();
        this.verifyResultNumbers();
        this.verifyIndexIsLocked(false, Dvd.class);
        this.verifyIndexIsLocked(true, Book.class);
    }

    @Test
    public void testCreationOfTheDefaultMassIndexer() throws Exception {
        FullTextSession fullTextSession = builder.openFullTextSession();
        MassIndexer indexer = fullTextSession.createIndexer(new Class[]{Object.class});
        Assert.assertThat((Object)indexer, (Matcher)CoreMatchers.instanceOf(MassIndexerImpl.class));
    }

    private void reindexAll() throws InterruptedException {
        FullTextSession fullTextSession = builder.openFullTextSession();
        SilentProgressMonitor progressMonitor = new SilentProgressMonitor();
        Assert.assertFalse((boolean)progressMonitor.finished);
        try {
            fullTextSession.createIndexer(new Class[]{Object.class}).threadsForSubsequentFetching(8).threadsToLoadObjects(4).batchSizeToLoadObjects(30).progressMonitor((MassIndexerProgressMonitor)progressMonitor).startAndWait();
        }
        finally {
            fullTextSession.close();
        }
        Assert.assertTrue((boolean)progressMonitor.finished);
    }

    private void purgeAll() {
        try (FullTextSession fullTextSession = builder.openFullTextSession();){
            Transaction tx = fullTextSession.beginTransaction();
            fullTextSession.purgeAll(Object.class);
            tx.commit();
        }
    }

    private void verifyIndexIsLocked(boolean isLocked, Class type) throws IOException {
        SearchIntegrator searchIntegrator = (SearchIntegrator)builder.getSearchFactory().unwrap(SearchIntegrator.class);
        IndexManager indexManager = searchIntegrator.getIndexBinding(type).getIndexManagers()[0];
        if (indexManager instanceof DirectoryBasedIndexManager) {
            Directory directory = ((DirectoryBasedIndexManager)indexManager).getDirectoryProvider().getDirectory();
            Assert.assertEquals((Object)isLocked, (Object)IndexWriter.isLocked((Directory)directory));
        }
    }

    private void verifyResultNumbers() {
        Assert.assertEquals((long)200L, (long)this.countByFT(Dvd.class));
        Assert.assertEquals((long)260L, (long)this.countByFT(Book.class));
        Assert.assertEquals((long)280L, (long)this.countByDatabaseCriteria(Book.class));
        Assert.assertEquals((long)20L, (long)this.countByDatabaseCriteria(SecretBook.class));
        Assert.assertEquals((long)120L, (long)this.countByFT(AncientBook.class));
        Assert.assertEquals((long)460L, (long)this.countByFT(AncientBook.class, Book.class, Dvd.class));
        Assert.assertEquals((long)320L, (long)this.countByFT(AncientBook.class, Dvd.class));
    }

    private void verifyIsEmpty() {
        Assert.assertEquals((long)0L, (long)this.countByFT(Dvd.class));
        Assert.assertEquals((long)0L, (long)this.countByFT(Book.class));
        Assert.assertEquals((long)0L, (long)this.countByFT(AncientBook.class));
        Assert.assertEquals((long)0L, (long)this.countByFT(AncientBook.class, Book.class, Dvd.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countByFT(Class<? extends TitleAble> ... types) {
        MatchAllDocsQuery findAll = new MatchAllDocsQuery();
        int bySize = 0;
        int byResultSize = 0;
        try (FullTextSession fullTextSession = builder.openFullTextSession();){
            Transaction tx = fullTextSession.beginTransaction();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)findAll, (Class[])types);
            bySize = fullTextQuery.list().size();
            byResultSize = fullTextQuery.getResultSize();
            tx.commit();
        }
        Assert.assertEquals((long)bySize, (long)byResultSize);
        return bySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long countByDatabaseCriteria(Class<? extends TitleAble> type) {
        try (FullTextSession session = builder.openFullTextSession();){
            long l;
            Transaction tx = session.beginTransaction();
            try {
                Number countAsNumber = (Number)session.createCriteria(type).setProjection(Projections.rowCount()).uniqueResult();
                l = countAsNumber.longValue();
            }
            catch (Throwable throwable) {
                tx.commit();
                throw throwable;
            }
            tx.commit();
            return l;
        }
    }

    private static class SilentProgressMonitor
    implements MassIndexerProgressMonitor {
        final AtomicLong objectsCounter = new AtomicLong();
        volatile boolean finished = false;

        private SilentProgressMonitor() {
        }

        public void documentsAdded(long increment) {
        }

        public void documentsBuilt(int number) {
        }

        public void entitiesLoaded(int size) {
        }

        public void addToTotalCount(long count) {
            this.objectsCounter.addAndGet(count);
        }

        public void indexingCompleted() {
            this.finished = true;
            log.debug((Object)("Finished indexing " + this.objectsCounter.get() + " entities"));
        }
    }
}

