/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.spatial;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Latitude;
import org.hibernate.search.annotations.Longitude;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class SpatialContainedInTest
extends SearchInitializationTestBase {
    @Test
    @TestForIssue(jiraKey="HSEARCH-2858")
    public void test() throws Exception {
        List results;
        FullTextQuery query;
        Query luceneQuery;
        QueryBuilder builder;
        FullTextSession ftSession2;
        this.init(Actor.class, ActorLocation.class);
        try (Session session = this.getTestResourceManager().openSession();){
            Actor actor1 = new Actor();
            actor1.setId(1L);
            ActorLocation location = new ActorLocation();
            location.setId(2L);
            location.setLat(24.0);
            location.setLon(31.5);
            actor1.setActorLocation(location);
            location.setActor(actor1);
            Transaction tx = session.beginTransaction();
            session.persist((Object)location);
            session.persist((Object)actor1);
            tx.commit();
        }
        session = this.getTestResourceManager().openSession();
        var2_2 = null;
        try {
            ftSession2 = Search.getFullTextSession((Session)session);
            builder = ftSession2.getSearchFactory().buildQueryBuilder().forEntity(Actor.class).get();
            luceneQuery = builder.spatial().onField("actorLocation.location").within(100.0, Unit.KM).ofLatitude(24.0).andLongitude(31.5).createQuery();
            query = ftSession2.createFullTextQuery(luceneQuery, new Class[]{Actor.class});
            results = query.list();
            Assert.assertEquals((long)1L, (long)results.size());
        }
        catch (Throwable ftSession2) {
            var2_2 = ftSession2;
            throw ftSession2;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable ftSession2) {
                        var2_2.addSuppressed(ftSession2);
                    }
                } else {
                    session.close();
                }
            }
        }
        session = this.getTestResourceManager().openSession();
        var2_2 = null;
        try {
            ActorLocation location = (ActorLocation)session.get(ActorLocation.class, (Serializable)Long.valueOf(2L));
            location.setLat(-24.0);
            location.setLon(-31.5);
            Transaction tx = session.beginTransaction();
            session.save((Object)location);
            tx.commit();
        }
        catch (Throwable location) {
            var2_2 = location;
            throw location;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable location) {
                        var2_2.addSuppressed(location);
                    }
                } else {
                    session.close();
                }
            }
        }
        session = this.getTestResourceManager().openSession();
        var2_2 = null;
        try {
            ftSession2 = Search.getFullTextSession((Session)session);
            builder = ftSession2.getSearchFactory().buildQueryBuilder().forEntity(Actor.class).get();
            luceneQuery = builder.spatial().onField("actorLocation.location").within(100.0, Unit.KM).ofLatitude(24.0).andLongitude(31.5).createQuery();
            query = ftSession2.createFullTextQuery(luceneQuery, new Class[]{Actor.class});
            results = query.list();
            Assert.assertEquals((long)0L, (long)results.size());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    @Entity
    @Spatial(name="location", spatialMode=SpatialMode.HASH)
    public static class ActorLocation {
        @Id
        private Long id;
        @ContainedIn
        @OneToOne(mappedBy="actorLocation")
        private Actor actor;
        @Latitude(of="location")
        private Double lat;
        @Longitude(of="location")
        private Double lon;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Actor getActor() {
            return this.actor;
        }

        public void setActor(Actor actor) {
            this.actor = actor;
        }

        public Double getLat() {
            return this.lat;
        }

        public void setLat(Double lat) {
            this.lat = lat;
        }

        public Double getLon() {
            return this.lon;
        }

        public void setLon(Double lon) {
            this.lon = lon;
        }
    }

    @Entity
    @Indexed
    public static class Actor {
        @Id
        private Long id;
        @Embedded
        @IndexedEmbedded
        @OneToOne
        private ActorLocation actorLocation;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public ActorLocation getActorLocation() {
            return this.actorLocation;
        }

        public void setActorLocation(ActorLocation actorLocation) {
            this.actorLocation = actorLocation;
        }
    }
}

