/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded;

import java.sql.Timestamp;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1494")
public class EmbeddedEntityNotIndexedTest {
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext configContext = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest((SearchConfiguration)searchConfiguration));
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testMultipleDocumentIdsCauseException() {
        TypeMetadata typeMetadata = this.metadataProvider.getTypeMetadataFor(A.class, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
        Assert.assertNull((String)"The id of B should not be indexed ", (Object)typeMetadata.getDocumentFieldMetadataFor("b.id"));
    }

    @Entity
    public class B {
        @Id
        @GeneratedValue
        private Timestamp id;
        @Field
        private String foo;

        public Timestamp getId() {
            return this.id;
        }

        public String getFoo() {
            return this.foo;
        }
    }

    @Entity
    @Indexed
    public class A {
        @Id
        @GeneratedValue
        private long id;
        @OneToOne
        @IndexedEmbedded
        private B b;
    }
}

