/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.reader.functionality;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.indexes.impl.SharingBufferReaderProvider;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;

public class ExtendedSharingBufferReaderProvider
extends SharingBufferReaderProvider {
    private static final int NUM_DIRECTORY_PROVIDERS = 3;
    private final Vector<MockIndexReader> createdReadersHistory = new Vector(500);
    final Map<Directory, TestManipulatorPerDP> manipulators = new ConcurrentHashMap<Directory, TestManipulatorPerDP>();
    private final RAMDirectoryProvider[] directories = new RAMDirectoryProvider[3];
    private final AtomicInteger currentDirectoryIndex = new AtomicInteger();
    private volatile RAMDirectoryProvider currentDirectory;

    public ExtendedSharingBufferReaderProvider() {
        for (int i = 0; i < 3; ++i) {
            TestManipulatorPerDP tm = new TestManipulatorPerDP(i);
            this.manipulators.put((Directory)tm.dp.getDirectory(), tm);
            this.directories[i] = tm.dp;
        }
        this.currentDirectory = this.directories[0];
    }

    public void currentDPWasWritten() {
        for (TestManipulatorPerDP manipulator : this.manipulators.values()) {
            manipulator.setIndexChanged();
        }
    }

    public void swithDirectory() {
        int index = this.currentDirectoryIndex.incrementAndGet();
        this.currentDirectory = this.directories[index % 3];
    }

    public boolean isReaderCurrent(MockIndexReader reader) {
        for (SharingBufferReaderProvider.PerDirectoryLatestReader latest : this.currentReaders.values()) {
            DirectoryReader latestReader = latest.current.reader;
            if (latestReader != reader) continue;
            return true;
        }
        return false;
    }

    protected DirectoryReader readerFactory(Directory directory) throws IOException {
        TestManipulatorPerDP manipulatorPerDP = this.manipulators.get(directory);
        if (!manipulatorPerDP.isReaderCreated.compareAndSet(false, true)) {
            throw new IllegalStateException("IndexReader created twice");
        }
        return new MockIndexReader(manipulatorPerDP.isIndexReaderCurrent);
    }

    public void initialize() {
        super.initialize((DirectoryBasedIndexManager)new MockDirectoryBasedIndexManager(), null);
    }

    public boolean areAllOldReferencesGone() {
        int numExpectedActiveReaders;
        int numReferencesReaders = this.allReaders.size();
        return numReferencesReaders == (numExpectedActiveReaders = this.manipulators.size());
    }

    public List<MockIndexReader> getCreatedIndexReaders() {
        return this.createdReadersHistory;
    }

    public class MockIndexReader
    extends DirectoryReader {
        private final AtomicBoolean closed;
        private final AtomicBoolean hasAlreadyBeenReOpened;
        private final AtomicBoolean isIndexReaderCurrent;

        MockIndexReader(AtomicBoolean isIndexReaderCurrent) throws IOException {
            super((Directory)new RAMDirectory(), new LeafReader[0]);
            this.closed = new AtomicBoolean(false);
            this.hasAlreadyBeenReOpened = new AtomicBoolean(false);
            this.isIndexReaderCurrent = isIndexReaderCurrent;
            if (!isIndexReaderCurrent.compareAndSet(false, true)) {
                throw new IllegalStateException("Unnecessarily reopened");
            }
            ExtendedSharingBufferReaderProvider.this.createdReadersHistory.add(this);
        }

        public final boolean isClosed() {
            return this.closed.get();
        }

        protected void doClose() throws IOException {
            boolean okToClose = this.closed.compareAndSet(false, true);
            if (!okToClose) {
                throw new IllegalStateException("Attempt to close a closed IndexReader");
            }
            if (!this.hasAlreadyBeenReOpened.get()) {
                throw new IllegalStateException("Attempt to close the most current IndexReader");
            }
        }

        public boolean hasDeletions() {
            return false;
        }

        protected DirectoryReader doOpenIfChanged() throws IOException {
            if (this.isIndexReaderCurrent.get()) {
                return null;
            }
            if (this.hasAlreadyBeenReOpened.compareAndSet(false, true)) {
                return new MockIndexReader(this.isIndexReaderCurrent);
            }
            throw new IllegalStateException("Attempt to reopen an old IndexReader more than once");
        }

        protected DirectoryReader doOpenIfChanged(IndexCommit commit) throws IOException {
            return this.doOpenIfChanged();
        }

        protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) throws IOException {
            return this.doOpenIfChanged();
        }

        public long getVersion() {
            return 0L;
        }

        public boolean isCurrent() throws IOException {
            return false;
        }

        public IndexCommit getIndexCommit() throws IOException {
            return null;
        }
    }

    public class MockDirectoryProvider
    implements DirectoryProvider<RAMDirectory> {
        public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        }

        public void start(DirectoryBasedIndexManager indexManager) {
        }

        public void stop() {
        }

        public RAMDirectory getDirectory() {
            return ExtendedSharingBufferReaderProvider.this.currentDirectory.getDirectory();
        }
    }

    public class MockDirectoryBasedIndexManager
    extends DirectoryBasedIndexManager {
        private final MockDirectoryProvider provider;

        public MockDirectoryBasedIndexManager() {
            this.provider = new MockDirectoryProvider();
        }

        public DirectoryProvider getDirectoryProvider() {
            return this.provider;
        }
    }

    public static class TestManipulatorPerDP {
        private final AtomicBoolean isIndexReaderCurrent = new AtomicBoolean(false);
        private final AtomicBoolean isReaderCreated = new AtomicBoolean(false);
        private final RAMDirectoryProvider dp = new RAMDirectoryProvider();

        TestManipulatorPerDP(int seed) {
            this.dp.initialize(String.valueOf(seed), new Properties(), (BuildContext)new BuildContextForTest((SearchConfiguration)new SearchConfigurationForTest()));
            this.dp.start(null);
        }

        public void setIndexChanged() {
            this.isIndexReaderCurrent.set(false);
        }
    }
}

