/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.sql.Connection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.resource.transaction.backend.jdbc.internal.DdlTransactionIsolatorNonJtaImpl;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.internal.exec.JdbcConnectionAccessConnectionProviderImpl;
import org.hibernate.tool.schema.internal.exec.JdbcConnectionAccessProvidedConnectionImpl;
import org.hibernate.tool.schema.internal.exec.JdbcContext;

final class DdlTransactionIsolatorTestingImpl
extends DdlTransactionIsolatorNonJtaImpl {
    public DdlTransactionIsolatorTestingImpl(ServiceRegistry serviceRegistry, Connection jdbConnection) {
        this(serviceRegistry, DdlTransactionIsolatorTestingImpl.createJdbcConnectionAccess(jdbConnection));
    }

    public static JdbcConnectionAccess createJdbcConnectionAccess(Connection jdbcConnection) {
        return new JdbcConnectionAccessProvidedConnectionImpl(jdbcConnection);
    }

    public DdlTransactionIsolatorTestingImpl(ServiceRegistry serviceRegistry, JdbcConnectionAccess jdbcConnectionAccess) {
        super(DdlTransactionIsolatorTestingImpl.createJdbcContext(jdbcConnectionAccess, serviceRegistry));
    }

    public static JdbcContext createJdbcContext(final JdbcConnectionAccess jdbcConnectionAccess, final ServiceRegistry serviceRegistry) {
        return new JdbcContext(){
            final JdbcServices jdbcServices;
            {
                this.jdbcServices = (JdbcServices)serviceRegistry.getService(JdbcServices.class);
            }

            public JdbcConnectionAccess getJdbcConnectionAccess() {
                return jdbcConnectionAccess;
            }

            public Dialect getDialect() {
                return this.jdbcServices.getJdbcEnvironment().getDialect();
            }

            public SqlStatementLogger getSqlStatementLogger() {
                return this.jdbcServices.getSqlStatementLogger();
            }

            public SqlExceptionHelper getSqlExceptionHelper() {
                return this.jdbcServices.getSqlExceptionHelper();
            }

            public ServiceRegistry getServiceRegistry() {
                return serviceRegistry;
            }
        };
    }

    public DdlTransactionIsolatorTestingImpl(ServiceRegistry serviceRegistry, ConnectionProvider connectionProvider) {
        this(serviceRegistry, DdlTransactionIsolatorTestingImpl.createJdbcConnectionAccess(connectionProvider));
    }

    private static JdbcConnectionAccess createJdbcConnectionAccess(ConnectionProvider connectionProvider) {
        return new JdbcConnectionAccessConnectionProviderImpl(connectionProvider);
    }
}

