/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.id.RegistrationId;
import org.hibernate.search.test.id.StudentEntity;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.setup.CountingErrorHandler;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CompositedIdMassIndexingTest {
    @Rule
    public FullTextSessionBuilder ftsBuilder = new FullTextSessionBuilder().addAnnotatedClass(RegistrationId.class).addAnnotatedClass(StudentEntity.class).setProperty("hibernate.search.error_handler", CountingErrorHandler.class.getName()).build();

    @Test
    public void testReindexingWithCompositeIds() throws InterruptedException {
        try (FullTextSession fullTextSession = this.ftsBuilder.openFullTextSession();){
            this.storeTestData((Session)fullTextSession);
        }
        fullTextSession = this.ftsBuilder.openFullTextSession();
        var2_2 = null;
        try {
            fullTextSession.createIndexer(new Class[0]).startAndWait();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (fullTextSession != null) {
                if (var2_2 != null) {
                    try {
                        fullTextSession.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    fullTextSession.close();
                }
            }
        }
        SearchFactory searchFactory = this.ftsBuilder.getSearchFactory();
        SearchIntegrator searchIntegrator = (SearchIntegrator)searchFactory.unwrap(SearchIntegrator.class);
        CountingErrorHandler errorHandler = (CountingErrorHandler)searchIntegrator.getErrorHandler();
        Assert.assertEquals((long)0L, (long)errorHandler.getTotalCount());
    }

    private void storeTestData(Session session) {
        Transaction tx = session.beginTransaction();
        RegistrationId firstId = new RegistrationId();
        firstId.setDepartment("Software Engineering");
        firstId.setStudentId(1);
        StudentEntity firstStudent = new StudentEntity();
        firstStudent.setRegid(firstId);
        firstStudent.setName("I am noone");
        session.save((Object)firstStudent);
        tx.commit();
        session.clear();
    }
}

