/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.query.facet.RangeFacet;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class WebShopTest
extends AbstractFacetTest {
    private static final Log log = (Log)LoggerFactory.make(Log.class);

    @Test
    public void testSimulateClient() {
        SearchService searchService = new SearchService(this.getSessionFactory());
        List<Car> cars = searchService.searchCar("BMW");
        Assert.assertEquals((String)"We should have matching cars", (long)12L, (long)cars.size());
        Map<String, List<FacetMenuItem>> facetMenuItems = searchService.getMenuItems();
        List<FacetMenuItem> colorMenuItems = facetMenuItems.get("color");
        Assert.assertEquals((String)"Wrong number of menu entries", (long)4L, (long)colorMenuItems.size());
        for (FacetMenuItem facetMenuItem : colorMenuItems) {
            Assert.assertFalse((boolean)facetMenuItem.isSelected());
        }
        List<FacetMenuItem> ccsMenuItems = facetMenuItems.get("cubicCapacity_Numeric");
        Assert.assertEquals((String)"Wrong number of menu entries", (long)3L, (long)ccsMenuItems.size());
        for (FacetMenuItem item : ccsMenuItems) {
            Assert.assertFalse((boolean)item.isSelected());
        }
        FacetMenuItem facetMenuItem = facetMenuItems.get("color").get(0);
        Assert.assertEquals((String)"Wrong facet count", (long)3L, (long)facetMenuItem.getCount());
        cars = searchService.selectMenuItem(facetMenuItem);
        Assert.assertEquals((String)"We should have matching cars", (long)3L, (long)cars.size());
        facetMenuItems = searchService.getMenuItems();
        colorMenuItems = facetMenuItems.get("color");
        Assert.assertEquals((String)"Wrong number of menu entries", (long)1L, (long)colorMenuItems.size());
        FacetMenuItem menuItem = colorMenuItems.get(0);
        Assert.assertEquals((String)"Wrong facet count", (long)3L, (long)menuItem.getCount());
        Assert.assertTrue((boolean)menuItem.isSelected());
        ccsMenuItems = facetMenuItems.get("cubicCapacity_Numeric");
        Assert.assertEquals((String)"Wrong number of menu entries", (long)3L, (long)ccsMenuItems.size());
        for (FacetMenuItem item : ccsMenuItems) {
            Assert.assertFalse((boolean)item.isSelected());
        }
        cars = searchService.deSelectMenuItem(menuItem);
        Assert.assertEquals((String)"We should have matching cars", (long)12L, (long)cars.size());
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        ArrayList allCars = CollectionHelper.newArrayList();
        for (String make : makes) {
            for (String color : colors) {
                for (int cc : ccs) {
                    Car car = new Car(make, color, cc);
                    session.save((Object)car);
                    allCars.add(car);
                }
            }
        }
        log.infof("Indexed cars: %s", (Object)allCars);
        tx.commit();
        session.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class};
    }

    static class FacetMenuItem {
        private final boolean isSelected;
        private final int index;
        private final String facetingName;
        private final Facet facet;

        public FacetMenuItem(Facet facet, boolean selected, int index) {
            this.isSelected = selected;
            this.facet = facet;
            this.facetingName = facet.getFacetingName();
            this.index = index;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public int getCount() {
            return this.facet.getCount();
        }

        public String getValue() {
            String value;
            if (this.facet instanceof RangeFacet) {
                RangeFacet rangeFacet = (RangeFacet)this.facet;
                value = rangeFacet.getMin().toString() + " - " + rangeFacet.getMax().toString();
            } else {
                value = this.facet.getValue();
            }
            return value;
        }

        public int getIndex() {
            return this.index;
        }

        public String getFacetingName() {
            return this.facetingName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FacetMenuItem");
            sb.append("{isSelected=").append(this.isSelected);
            sb.append(", facet=").append(this.facet);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class SearchService {
        public static final String colorFacetName = "color";
        public static final String cubicCapacityFacetName = "cubicCapacity_Numeric";
        private final SessionFactory factory;
        private FullTextQuery currentFullTextQuery;
        private Map<String, List<FacetMenuItem>> menuItems;
        private String queryString;
        private final List<Facet> selectedFacets = CollectionHelper.newArrayList();

        public SearchService(SessionFactory factory) {
            this.factory = factory;
        }

        private List<Car> searchCar(String queryString) {
            this.queryString = queryString;
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.factory.openSession());
            this.buildFullTextQuery(queryString, fullTextSession);
            Transaction tx = fullTextSession.beginTransaction();
            List cars = this.currentFullTextQuery.list();
            tx.commit();
            fullTextSession.close();
            return cars;
        }

        private void buildFullTextQuery(String queryString, FullTextSession fullTextSession) {
            QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Car.class).get();
            Query query = builder.keyword().onField("make").matching((Object)queryString).createQuery();
            FacetingRequest colorFacet = builder.facet().name(colorFacetName).onField(colorFacetName).discrete().createFacetingRequest();
            FacetingRequest priceFacet = builder.facet().name(cubicCapacityFacetName).onField("cubicCapacity_string_facet_numeric").range().below((Object)2500).excludeLimit().from((Object)2500).to((Object)3000).above((Object)3000).excludeLimit().createFacetingRequest();
            this.currentFullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Car.class});
            this.currentFullTextQuery.setFirstResult(0).setMaxResults(20);
            this.currentFullTextQuery.getFacetManager().enableFaceting(colorFacet).enableFaceting(priceFacet);
        }

        public Map<String, List<FacetMenuItem>> getMenuItems() {
            this.menuItems = CollectionHelper.newHashMap();
            ArrayList items = CollectionHelper.newArrayList();
            int i = 0;
            for (Facet facet : this.currentFullTextQuery.getFacetManager().getFacets(colorFacetName)) {
                items.add(new FacetMenuItem(facet, this.selectedFacets.contains(facet), i));
                ++i;
            }
            this.menuItems.put(colorFacetName, items);
            items = CollectionHelper.newArrayList();
            i = 0;
            for (Facet facet : this.currentFullTextQuery.getFacetManager().getFacets(cubicCapacityFacetName)) {
                items.add(new FacetMenuItem(facet, this.selectedFacets.contains(facet), i++));
            }
            this.menuItems.put(cubicCapacityFacetName, items);
            return this.menuItems;
        }

        public List<Car> selectMenuItem(FacetMenuItem item) {
            List facets = this.currentFullTextQuery.getFacetManager().getFacets(item.getFacetingName());
            Facet facet = (Facet)facets.get(item.getIndex());
            this.selectedFacets.add(facet);
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.factory.openSession());
            this.buildFullTextQuery(this.queryString, fullTextSession);
            Transaction tx = fullTextSession.beginTransaction();
            this.currentFullTextQuery.getFacetManager().getFacetGroup(item.getFacetingName()).selectFacets(this.selectedFacets.toArray(new Facet[this.selectedFacets.size()]));
            List cars = this.currentFullTextQuery.list();
            tx.commit();
            fullTextSession.close();
            return cars;
        }

        public List<Car> deSelectMenuItem(FacetMenuItem item) {
            List facets = this.currentFullTextQuery.getFacetManager().getFacets(item.getFacetingName());
            Facet facet = (Facet)facets.get(item.getIndex());
            this.selectedFacets.remove(facet);
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.factory.openSession());
            this.buildFullTextQuery(this.queryString, fullTextSession);
            Transaction tx = fullTextSession.beginTransaction();
            this.currentFullTextQuery.getFacetManager().getFacetGroup(item.getFacetingName()).selectFacets(this.selectedFacets.toArray(new Facet[0]));
            List cars = this.currentFullTextQuery.list();
            tx.commit();
            fullTextSession.close();
            return cars;
        }
    }
}

