/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.hcore.util.impl.HibernateHelper;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.hibernate.impl.LoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ObjectLoaderHelper {
    private static final Log log = LoggerFactory.make();

    private ObjectLoaderHelper() {
    }

    public static Object load(EntityInfo entityInfo, SessionImplementor session) {
        Object maybeProxy = ObjectLoaderHelper.executeLoad(entityInfo, session);
        try {
            HibernateHelper.initialize(maybeProxy);
        }
        catch (RuntimeException e) {
            if (LoaderHelper.isObjectNotFoundException(e)) {
                log.debugf("Object found in Search index but not in database: %s with id %s", (Object)entityInfo.getType().getName(), (Object)entityInfo.getId());
                session.evict(maybeProxy);
                maybeProxy = null;
            }
            throw e;
        }
        return maybeProxy;
    }

    private static Object executeLoad(EntityInfo entityInfo, SessionImplementor session) {
        Object maybeProxy;
        if (ObjectLoaderHelper.areDocIdAndEntityIdIdentical(entityInfo, session)) {
            maybeProxy = session.byId(entityInfo.getType().getPojoType()).load(entityInfo.getId());
        } else {
            CriteriaImpl criteria = new CriteriaImpl(entityInfo.getType().getName(), (SharedSessionContractImplementor)session);
            criteria.add((Criterion)Restrictions.eq((String)entityInfo.getIdName(), (Object)entityInfo.getId()));
            try {
                maybeProxy = criteria.uniqueResult();
            }
            catch (HibernateException e) {
                throw new SearchException("Loading entity of type " + entityInfo.getType().getName() + " using '" + entityInfo.getIdName() + "' as document id and '" + entityInfo.getId() + "' as value was not unique");
            }
        }
        return maybeProxy;
    }

    public static boolean areDocIdAndEntityIdIdentical(EntityInfo entityInfo, SessionImplementor session) {
        SessionFactoryImplementor sessionFactoryImplementor = session.getSessionFactory();
        ClassMetadata cm = sessionFactoryImplementor.getMetamodel().entityPersister(entityInfo.getType().getName()).getClassMetadata();
        String hibernateIdentifierProperty = cm.getIdentifierPropertyName();
        return entityInfo.getIdName().equals(hibernateIdentifierProperty);
    }
}

