/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.update;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class UpdateIndexedEmbeddedCollectionTest
extends SearchTestBase {
    @TestForIssue(jiraKey="HSEARCH-734")
    @Test
    public void testUpdateIndexedEmbeddedCollectionWithNull() throws Exception {
        Driver driverSmith = new Driver("Mark", "Smith");
        Truck truckLVN746XD = new Truck("LVN 746 XD");
        driverSmith.setTruck(truckLVN746XD);
        Item item1 = new Item("Sofa", 1);
        Item item2 = new Item("Table", 3);
        Item item3 = new Item("Chair", 24);
        HashSet<Item> itemsTruckLVN746XD = new HashSet<Item>();
        itemsTruckLVN746XD.add(item1);
        itemsTruckLVN746XD.add(item2);
        itemsTruckLVN746XD.add(item3);
        truckLVN746XD.setItems(itemsTruckLVN746XD);
        Driver driverDoe = new Driver("John", "Doe");
        Truck truckMLN666DJ = new Truck("MLN 666 DJ");
        driverDoe.setTruck(truckMLN666DJ);
        Item item4 = new Item("Armchair", 8);
        Item item5 = new Item("Chair", 19);
        HashSet<Item> itemsTruckMLN666DJ = new HashSet<Item>();
        itemsTruckMLN666DJ.add(item4);
        itemsTruckMLN666DJ.add(item5);
        truckMLN666DJ.setItems(itemsTruckMLN666DJ);
        FullTextSession session = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = session.beginTransaction();
        session.save((Object)driverSmith);
        session.save((Object)driverDoe);
        tx.commit();
        session.close();
        Long truckLVN746XDId = truckLVN746XD.getId();
        Long truckMLN666DJId = truckMLN666DJ.getId();
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        Assert.assertEquals((Object)truckMLN666DJId, (Object)this.findTruckIdFromIndex(session, "armchair"));
        Assert.assertEquals((Object)truckLVN746XDId, (Object)this.findTruckIdFromIndex(session, "table"));
        tx.commit();
        session.close();
        truckLVN746XD.setItems(null);
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        session.update((Object)driverSmith);
        tx.commit();
        session.close();
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        Assert.assertNull((Object)this.findTruckIdFromIndex(session, "table"));
        tx.commit();
        session.close();
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        session.delete((Object)driverSmith);
        session.delete((Object)driverDoe);
        tx.commit();
        session.close();
    }

    private Long findTruckIdFromIndex(FullTextSession session, String itemDescription) {
        FullTextQuery q = session.createFullTextQuery((Query)new TermQuery(new Term("truck.items.description", itemDescription)), new Class[]{Driver.class});
        q.setProjection(new String[]{"truck.id"});
        List results = q.list();
        if (results.isEmpty()) {
            return null;
        }
        return (Long)((Object[])results.get(0))[0];
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Driver.class, Truck.class, Item.class};
    }

    @Entity(name="Item")
    @Indexed
    public static class Item {
        private Long id;
        private String description;
        private Integer quantity;

        public Item(String description, Integer quantity) {
            this.description = description;
            this.quantity = quantity;
        }

        public Item() {
        }

        @Id
        @GeneratedValue
        @DocumentId
        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        @Field
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Field
        public Integer getQuantity() {
            return this.quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }
    }

    @Entity(name="Truck")
    @Indexed
    public static class Truck {
        private Long id;
        private String numberPlate;
        private Set<Item> items;

        public Truck(String numberPlate) {
            this.numberPlate = numberPlate;
        }

        public Truck() {
        }

        @Id
        @GeneratedValue
        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        @Field
        public String getNumberPlate() {
            return this.numberPlate;
        }

        public void setNumberPlate(String numberPlate) {
            this.numberPlate = numberPlate;
        }

        @IndexedEmbedded
        @OneToMany(cascade={CascadeType.ALL})
        public Set<Item> getItems() {
            return this.items;
        }

        public void setItems(Set<Item> items) {
            this.items = items;
        }
    }

    @Entity(name="Driver")
    @Indexed
    public static class Driver {
        private Long id;
        private String firstName;
        private String lastName;
        private Truck truck;

        public Driver(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public Driver() {
        }

        @Id
        @GeneratedValue
        @DocumentId
        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        @Field
        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Field
        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @IndexedEmbedded(includeEmbeddedObjectId=true)
        @OneToOne(cascade={CascadeType.ALL})
        public Truck getTruck() {
            return this.truck;
        }

        public void setTruck(Truck truck) {
            this.truck = truck;
        }
    }
}

