/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.boost.embeddable;

import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.ManyToOne;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.query.boost.embeddable.LocalizedTitle;
import org.hibernate.search.test.query.boost.embeddable.SubTitle;

@Embeddable
public class Title {
    @Field
    private String value;
    @IndexedEmbedded(includePaths={"value"})
    @Boost(value=0.5f)
    private SubTitle subTitle;
    @IndexedEmbedded(includePaths={"value"})
    @ManyToOne(cascade={CascadeType.ALL})
    private LocalizedTitle localizedTitle;

    Title() {
    }

    public Title(String value) {
        this.value = value;
    }

    public Title(String value, String subTitle) {
        this.value = value;
        this.subTitle = new SubTitle(subTitle);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SubTitle getSubTitle() {
        return this.subTitle;
    }

    public void setSubTitle(SubTitle subTitle) {
        this.subTitle = subTitle;
    }

    public LocalizedTitle getLocalizedTitle() {
        return this.localizedTitle;
    }

    public void setLocalizedTitle(LocalizedTitle localizedTitle) {
        this.localizedTitle = localizedTitle;
    }

    public String toString() {
        return "Title [value=" + this.value + ", subTitle=" + this.subTitle + ", localizedTitle=" + this.localizedTitle + "]";
    }
}

