/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.objectloading;

import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.objectloading.TestEntity;
import org.hibernate.search.testsupport.BytemanHelper;
import org.hibernate.search.testsupport.TestForIssue;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@TestForIssue(jiraKey="HSEARCH-704")
@RunWith(value=BMUnitRunner.class)
public class ObjectLoaderHelperTest
extends SearchTestBase {
    @Rule
    public BytemanHelper.BytemanAccessor byteman = BytemanHelper.createAccessor();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        for (int i = 0; i < 100; ++i) {
            TestEntity entity = new TestEntity(i, "document-" + i);
            fullTextSession.persist((Object)entity);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    @BMRule(targetClass="org.hibernate.internal.CriteriaImpl", targetMethod="<init>(String, String, org.hibernate.engine.spi.SharedSessionContractImplementor)", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="testOnlyOneCriteriaQueryIsUsedToLoadMatchedEntities")
    public void testOnlyOneCriteriaQueryIsUsedToLoadMatchedEntities() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        MatchAllDocsQuery luceneQuery = new MatchAllDocsQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)luceneQuery, new Class[]{TestEntity.class});
        int hitCount = fullTextQuery.list().size();
        Assert.assertEquals((String)"Wrong hit count", (long)100L, (long)hitCount);
        tx.commit();
        fullTextSession.close();
        Assert.assertEquals((String)"There should be only a single criteria query (CriteriaObjectsInitializer)", (long)1L, (long)this.byteman.getAndResetInvocationCount());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{TestEntity.class};
    }
}

