/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.serialization;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.impl.StandardServiceManager;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.serialization.impl.CopyTokenStream;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.test.serialization.RemoteEntity;
import org.hibernate.search.test.util.SerializationTestHelper;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProtocolBackwardCompatibilityTest {
    private static final String RESOURCE_BASE_NAME = "persistent-work-avro-";
    private static final IndexedTypeIdentifier remoteTypeId = new PojoIndexedTypeIdentifier(RemoteEntity.class);
    @Rule
    public SearchFactoryHolder searchFactoryHolder = new SearchFactoryHolder(new Class[]{RemoteEntity.class});
    private LuceneWorkSerializer luceneWorkSerializer;

    @Before
    public void setUp() throws Exception {
        ServiceManager serviceManager = this.getTestServiceManager();
        this.luceneWorkSerializer = (LuceneWorkSerializer)serviceManager.requestService(LuceneWorkSerializer.class);
        List<LuceneWork> workList = this.buildV10Works();
        workList.addAll(this.buildV11Works());
        workList.addAll(this.buildV12Works());
        this.serializeWithAvro(workList);
    }

    private ServiceManager getTestServiceManager() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        return new StandardServiceManager((SearchConfiguration)new SearchConfigurationForTest(), (BuildContext)new BuildContextForTest((SearchConfiguration)searchConfiguration){

            public ExtendedSearchIntegrator getUninitializedSearchIntegrator() {
                return ProtocolBackwardCompatibilityTest.this.searchFactoryHolder.getSearchFactory();
            }
        });
    }

    @Test
    public void testDeserializingVersion10ModelWithLatestDeserializer() throws Exception {
        List<LuceneWork> expectedWorkList = this.buildV10Works();
        byte[] serializedModelV10 = this.loadSerializedWorkForMajorMinor(1, 0);
        List actualWorkList = this.luceneWorkSerializer.toLuceneWorks(serializedModelV10);
        SerializationTestHelper.assertLuceneWorkList(expectedWorkList, actualWorkList);
    }

    @Test
    public void testDeserializingVersion11ModelWithLatestDeserializer() throws Exception {
        List<LuceneWork> expectedWorkList = this.buildV10Works();
        expectedWorkList.addAll(this.buildV11Works());
        byte[] serializedModelV11 = this.loadSerializedWorkForMajorMinor(1, 1);
        List actualWorkList = this.luceneWorkSerializer.toLuceneWorks(serializedModelV11);
        SerializationTestHelper.assertLuceneWorkList(expectedWorkList, actualWorkList);
    }

    @Test
    public void testDeserializingVersion12AvroVersion17ModelWithLatestDeserializer() throws Exception {
        List<LuceneWork> expectedWorkList = this.buildV10Works();
        expectedWorkList.addAll(this.buildV11Works());
        expectedWorkList.addAll(this.buildV12Works());
        byte[] serializedModelV12Avro17 = this.loadSerializedWorkForMajorMinorQualifier(1, 2, "avro17");
        List actualWorkList = this.luceneWorkSerializer.toLuceneWorks(serializedModelV12Avro17);
        SerializationTestHelper.assertLuceneWorkList(expectedWorkList, actualWorkList);
    }

    @Test
    public void testDeserializingVersion12AvroVersion19ModelWithLatestDeserializer() throws Exception {
        List<LuceneWork> expectedWorkList = this.buildV10Works();
        expectedWorkList.addAll(this.buildV11Works());
        expectedWorkList.addAll(this.buildV12Works());
        byte[] serializedModelV12Avro19 = this.loadSerializedWorkForMajorMinorQualifier(1, 2, "avro19");
        List actualWorkList = this.luceneWorkSerializer.toLuceneWorks(serializedModelV12Avro19);
        SerializationTestHelper.assertLuceneWorkList(expectedWorkList, actualWorkList);
    }

    private List<LuceneWork> buildV10Works() throws Exception {
        ArrayList<LuceneWork> works = new ArrayList<LuceneWork>();
        works.add((LuceneWork)OptimizeLuceneWork.INSTANCE);
        works.add((LuceneWork)OptimizeLuceneWork.INSTANCE);
        works.add((LuceneWork)new OptimizeLuceneWork(remoteTypeId));
        works.add((LuceneWork)new PurgeAllLuceneWork(remoteTypeId));
        works.add((LuceneWork)new PurgeAllLuceneWork(remoteTypeId));
        works.add((LuceneWork)new DeleteLuceneWork((Serializable)Long.valueOf(123L), "123", remoteTypeId));
        works.add((LuceneWork)new DeleteLuceneWork((Serializable)((Object)"Sissi"), "Sissi", remoteTypeId));
        works.add((LuceneWork)new DeleteLuceneWork((Serializable)new URL("http://emmanuelbernard.com"), "http://emmanuelbernard.com", remoteTypeId));
        Document doc = new Document();
        DoubleField numField = new DoubleField("double", 23.0, Field.Store.NO);
        doc.add((IndexableField)numField);
        numField = new IntField("int", 23, Field.Store.NO);
        doc.add((IndexableField)numField);
        numField = new FloatField("float", 2.3f, Field.Store.NO);
        doc.add((IndexableField)numField);
        numField = new LongField("long", 23L, Field.Store.NO);
        doc.add((IndexableField)numField);
        HashMap<String, String> analyzers = new HashMap<String, String>();
        analyzers.put("godo", "ngram");
        works.add((LuceneWork)new AddLuceneWork((Serializable)Integer.valueOf(123), "123", remoteTypeId, doc, analyzers));
        doc = new Document();
        Field field = new Field("StringF", "String field", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_OFFSETS);
        field.setBoost(3.0f);
        doc.add((IndexableField)field);
        field = new Field("StringF2", "String field 2", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_OFFSETS);
        doc.add((IndexableField)field);
        byte[] array = new byte[]{2, 5, 5, 8};
        field = new Field("binary", array, 0, array.length);
        doc.add((IndexableField)field);
        SerializationTestHelper.SerializableStringReader reader = new SerializationTestHelper.SerializableStringReader();
        field = new Field("ReaderField", (Reader)reader, Field.TermVector.WITH_OFFSETS);
        doc.add((IndexableField)field);
        List<List<AttributeImpl>> tokens = SerializationTestHelper.buildTokenStreamWithAttributes();
        CopyTokenStream tokenStream = new CopyTokenStream(tokens);
        field = new Field("tokenstream", (TokenStream)tokenStream, Field.TermVector.WITH_POSITIONS_OFFSETS);
        field.setBoost(3.0f);
        doc.add((IndexableField)field);
        works.add((LuceneWork)new UpdateLuceneWork((Serializable)Integer.valueOf(1234), "1234", remoteTypeId, doc));
        works.add((LuceneWork)new AddLuceneWork((Serializable)Integer.valueOf(125), "125", remoteTypeId, new Document()));
        return works;
    }

    private List<LuceneWork> buildV11Works() throws Exception {
        ArrayList<LuceneWork> works = new ArrayList<LuceneWork>();
        works.add((LuceneWork)FlushLuceneWork.INSTANCE);
        return works;
    }

    private List<LuceneWork> buildV12Works() throws Exception {
        ArrayList<LuceneWork> works = new ArrayList<LuceneWork>();
        Document document = new Document();
        document.add((IndexableField)new NumericDocValuesField("foo", 22L));
        document.add((IndexableField)new BinaryDocValuesField("foo", new BytesRef((CharSequence)"world")));
        document.add((IndexableField)new SortedSetDocValuesField("foo", new BytesRef((CharSequence)"hello")));
        document.add((IndexableField)new SortedDocValuesField("foo", new BytesRef((CharSequence)"world")));
        works.add((LuceneWork)new AddLuceneWork((Serializable)Integer.valueOf(123), "123", remoteTypeId, document));
        return works;
    }

    private byte[] serializeWithAvro(List<LuceneWork> works) throws Exception {
        byte[] serializedWork = this.luceneWorkSerializer.toSerializedModel(works);
        this.storeSerializedForm(serializedWork, 1, 2);
        return serializedWork;
    }

    private void storeSerializedForm(byte[] out, int major, int minor) throws IOException {
        Path targetDir = this.getTargetDir();
        Path outputFilePath = targetDir.resolve(RESOURCE_BASE_NAME + major + "." + minor);
        try (FileOutputStream outputStream = new FileOutputStream(outputFilePath.toFile());){
            ((OutputStream)outputStream).write(out);
            outputStream.flush();
        }
    }

    private byte[] loadSerializedWorkForMajorMinor(int major, int minor) throws Exception {
        return this.loadSerializedWorkForMajorMinorQualifier(major, minor, null);
    }

    private byte[] loadSerializedWorkForMajorMinorQualifier(int major, int minor, String qualifier) throws Exception {
        StringBuilder pathBuilder = new StringBuilder(RESOURCE_BASE_NAME + major + "." + minor);
        if (qualifier != null) {
            pathBuilder.append("-");
            pathBuilder.append(qualifier);
        }
        URL url = this.getClass().getClassLoader().getResource(pathBuilder.toString());
        URI uri = url.toURI();
        Path path = Paths.get(uri);
        return Files.readAllBytes(path);
    }

    private Path getTargetDir() {
        URI classesDirUri;
        try {
            classesDirUri = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return Paths.get(classesDirUri).getParent();
    }
}

