/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import org.hibernate.search.SearchFactory;
import org.hibernate.search.query.dsl.v2.EntityContext;
import org.hibernate.search.query.dsl.v2.QueryBuilder;
import org.hibernate.search.query.dsl.v2.QueryContextBuilder;
import org.hibernate.search.query.dsl.v2.impl.ConnectedQueryBuilder;
import org.hibernate.search.util.ScopedAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedQueryContextBuilder
implements QueryContextBuilder {
    private final SearchFactory factory;

    public ConnectedQueryContextBuilder(SearchFactory factory) {
        this.factory = factory;
    }

    @Override
    public EntityContext forEntity(Class<?> entityType) {
        return new HSearchEntityContext(entityType, this.factory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class HSearchEntityContext
    implements EntityContext {
        private final ScopedAnalyzer queryAnalyzer;
        private final SearchFactory factory;

        public HSearchEntityContext(Class<?> entityType, SearchFactory factory) {
            this.factory = factory;
            this.queryAnalyzer = new ScopedAnalyzer();
            this.queryAnalyzer.setGlobalAnalyzer(factory.getAnalyzer(entityType));
        }

        @Override
        public EntityContext overridesForField(String field, String analyzerName) {
            this.queryAnalyzer.addScopedAnalyzer(field, this.factory.getAnalyzer(analyzerName));
            return this;
        }

        @Override
        public QueryBuilder get() {
            return new ConnectedQueryBuilder(this.queryAnalyzer, this.factory);
        }
    }
}

