/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2010, Red Hat, Inc. and/or its affiliates or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat, Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 */
package org.hibernate.search.bridge.builtin;

import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.DateTools.Resolution;
import org.hibernate.AssertionFailure;

public class DateResolutionUtil {
	
	private DateResolutionUtil() {}
	
	
	public static Resolution getLuceneResolution(org.hibernate.search.annotations.Resolution hibResolution) {
		Resolution resolution = null;
		switch (hibResolution) {
			case YEAR:
				resolution = DateTools.Resolution.YEAR;
				break;
			case MONTH:
				resolution = DateTools.Resolution.MONTH;
				break;
			case DAY:
				resolution = DateTools.Resolution.DAY;
				break;
			case HOUR:
				resolution = DateTools.Resolution.HOUR;
				break;
			case MINUTE:
				resolution = DateTools.Resolution.MINUTE;
				break;
			case SECOND:
				resolution = DateTools.Resolution.SECOND;
				break;
			case MILLISECOND:
				resolution = DateTools.Resolution.MILLISECOND;
				break;
			default:
				throw new AssertionFailure( "Unknown Resolution: " + hibResolution );
		}
		return resolution;
	}
}
