/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.analyzer.MyComponent;
import org.hibernate.search.test.analyzer.Test1Analyzer;
import org.hibernate.search.test.analyzer.Test2Analyzer;
import org.hibernate.search.test.analyzer.Test3Analyzer;

@Entity
@Indexed(index="idx1")
@Analyzer(impl=Test1Analyzer.class)
public class MyEntity {
    @Id
    @GeneratedValue
    @DocumentId
    private Integer id;
    @Field(index=Index.TOKENIZED)
    private String entity;
    @Field(index=Index.TOKENIZED)
    @Analyzer(impl=Test2Analyzer.class)
    private String property;
    @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=Test3Analyzer.class))
    @Analyzer(impl=Test2Analyzer.class)
    private String field;
    @Field(index=Index.UN_TOKENIZED)
    private String notAnalyzed;
    @IndexedEmbedded
    @Embedded
    private MyComponent component;

    public String getNotAnalyzed() {
        return this.notAnalyzed;
    }

    public void setNotAnalyzed(String notAnalyzed) {
        this.notAnalyzed = notAnalyzed;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public MyComponent getComponent() {
        return this.component;
    }

    public void setComponent(MyComponent component) {
        this.component = component;
    }
}

