/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.util.Properties;
import junit.framework.TestCase;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;

public class ConfigurationParseHelperTest
extends TestCase {
    public void testIntegerParsers() {
        ConfigurationParseHelperTest.assertEquals((int)0, (int)ConfigurationParseHelper.parseInt((String)"   0 ", (String)"not important"));
        ConfigurationParseHelperTest.assertEquals((int)8, (int)ConfigurationParseHelper.parseInt(null, (int)8, null));
        ConfigurationParseHelperTest.assertEquals((int)56, (int)ConfigurationParseHelper.parseInt((String)"56", (int)8, null));
        Properties props = new Properties();
        props.setProperty("value1", "58");
        ConfigurationParseHelperTest.assertEquals((int)58, (int)ConfigurationParseHelper.getIntValue((Properties)props, (String)"value1", (int)8));
        ConfigurationParseHelperTest.assertEquals((int)8, (int)ConfigurationParseHelper.getIntValue((Properties)props, (String)"value2", (int)8));
        props.setProperty("value2", "nand");
        boolean exceptionLaunched = false;
        try {
            ConfigurationParseHelper.getIntValue((Properties)props, (String)"value2", (int)8);
        }
        catch (SearchException e) {
            exceptionLaunched = true;
        }
        ConfigurationParseHelperTest.assertTrue((boolean)exceptionLaunched);
    }

    public void testBooleanParsers() {
        ConfigurationParseHelperTest.assertTrue((boolean)ConfigurationParseHelper.parseBoolean((String)"true", null));
        ConfigurationParseHelperTest.assertTrue((boolean)ConfigurationParseHelper.parseBoolean((String)" True ", null));
        ConfigurationParseHelperTest.assertFalse((boolean)ConfigurationParseHelper.parseBoolean((String)"false", null));
        ConfigurationParseHelperTest.assertFalse((boolean)ConfigurationParseHelper.parseBoolean((String)" False  ", null));
        boolean exceptionLaunched = false;
        try {
            ConfigurationParseHelper.parseBoolean((String)"5", (String)"error");
        }
        catch (SearchException e) {
            exceptionLaunched = true;
        }
        ConfigurationParseHelperTest.assertTrue((boolean)exceptionLaunched);
        exceptionLaunched = false;
        try {
            ConfigurationParseHelper.parseBoolean(null, (String)"error");
        }
        catch (SearchException e) {
            exceptionLaunched = true;
        }
        ConfigurationParseHelperTest.assertTrue((boolean)exceptionLaunched);
    }
}

