/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.TestCase;
import org.hibernate.search.backend.configuration.MaskedProperty;
import org.hibernate.search.test.SerializationTestHelper;

public class MaskedPropertiesTest
extends TestCase {
    public void testConfigurationParsingPrecedence() {
        Properties cfg = new Properties();
        cfg.put("hibernate.search.Animals.transaction.indexwriter.max_merge_docs", "1");
        cfg.put("hibernate.search.Animals.2.transaction.indexwriter.max_merge_docs", "2");
        cfg.put("hibernate.search.Animals.2.transaction.max_merge_docs", "3");
        cfg.put("hibernate.search.Animals.transaction.max_merge_docs", "5");
        cfg.put("hibernate.search.default.transaction.max_merge_docs", "6");
        cfg.put("hibernate.search.default.transaction.indexwriter.max_field_length", "7");
        cfg.put("hibernate.notsearch.tests.default", "7");
        MaskedProperty root = new MaskedProperty(cfg, "hibernate.search");
        MaskedProperty common = new MaskedProperty((Properties)root, "default");
        MaskedProperty dirProvider = new MaskedProperty((Properties)root, "Animals", (Properties)common);
        MaskedProperty transaction = new MaskedProperty((Properties)dirProvider, "transaction");
        MaskedProperty shard2 = new MaskedProperty((Properties)dirProvider, "2", (Properties)dirProvider);
        MaskedProperty transactionInShard2 = new MaskedProperty((Properties)shard2, "transaction", (Properties)transaction);
        MaskedProperty newStyleTransaction = new MaskedProperty((Properties)transaction, "indexwriter", (Properties)transaction);
        MaskedProperty newStyleTransactionInShard2 = new MaskedProperty((Properties)transactionInShard2, "indexwriter", (Properties)transactionInShard2);
        MaskedPropertiesTest.assertEquals((String)"7", (String)newStyleTransaction.getProperty("max_field_length"));
        MaskedPropertiesTest.assertEquals((String)"7", (String)newStyleTransactionInShard2.getProperty("max_field_length"));
        MaskedPropertiesTest.assertEquals((String)"5", (String)transaction.getProperty("max_merge_docs"));
        Enumeration<?> propertyNames = newStyleTransaction.propertyNames();
        int count = 0;
        while (propertyNames.hasMoreElements()) {
            ++count;
            System.out.println(propertyNames.nextElement());
        }
    }

    public void testSerializability() throws IOException, ClassNotFoundException {
        Properties cfg = new Properties();
        cfg.setProperty("base.key", "value");
        MaskedProperty originalProps = new MaskedProperty(cfg, "base");
        MaskedProperty theCopy = (MaskedProperty)SerializationTestHelper.duplicateBySerialization(originalProps);
        MaskedPropertiesTest.assertEquals((String)"value", (String)theCopy.getProperty("key"));
    }

    public void testListingKeys() {
        Properties defaultProp = new Properties();
        defaultProp.put("some.inherited.prop", "to test standard Properties fallback behaviour");
        Properties rootProp = new Properties(defaultProp);
        rootProp.put("some.long.dotted.prop1", "hello!");
        rootProp.put("hidden.long.dotted.prop2", "hello again");
        Properties fallbackProp = new Properties();
        fallbackProp.put("default.long.dotted.prop3", "hello!");
        MaskedProperty masked = new MaskedProperty(rootProp, "some", fallbackProp);
        MaskedPropertiesTest.assertTrue((boolean)masked.keySet().contains("long.dotted.prop1"));
        MaskedPropertiesTest.assertTrue((boolean)masked.keySet().contains("default.long.dotted.prop3"));
        MaskedPropertiesTest.assertTrue((boolean)masked.keySet().contains("inherited.prop"));
        MaskedPropertiesTest.assertFalse((boolean)masked.keySet().contains("hidden.long.dotted.prop2"));
        MaskedPropertiesTest.assertFalse((boolean)masked.keySet().contains("long.dotted.prop2"));
        MaskedProperty maskedAgain = new MaskedProperty((Properties)masked, "long.dotted", (Properties)masked);
        MaskedPropertiesTest.assertTrue((boolean)maskedAgain.keySet().contains("prop1"));
        MaskedPropertiesTest.assertTrue((boolean)maskedAgain.keySet().contains("long.dotted.prop1"));
        MaskedPropertiesTest.assertTrue((boolean)maskedAgain.keySet().contains("default.long.dotted.prop3"));
        MaskedProperty maskingAll = new MaskedProperty((Properties)masked, "secured");
        MaskedPropertiesTest.assertTrue((boolean)maskingAll.keySet().isEmpty());
        MaskedPropertiesTest.assertTrue((boolean)maskingAll.isEmpty());
    }
}

