/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import junit.framework.TestCase;
import org.hibernate.HibernateException;
import org.hibernate.search.SearchException;
import org.hibernate.search.test.directoryProvider.CustomLockFactoryFactory;
import org.hibernate.search.test.directoryProvider.SnowStorm;
import org.hibernate.search.test.util.FullTextSessionBuilder;

public class CustomLockProviderTest
extends TestCase {
    public void testUseOfCustomLockingFactory() {
        CustomLockProviderTest.assertNull((Object)CustomLockFactoryFactory.optionValue);
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        builder.addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.locking_option", "somethingHere").setProperty("hibernate.search.default.locking_strategy", "org.hibernate.search.test.directoryProvider.CustomLockFactoryFactory").build();
        builder.close();
        CustomLockProviderTest.assertEquals((String)"somethingHere", (String)CustomLockFactoryFactory.optionValue);
    }

    public void testFailOnInexistentLockingFactory() {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        try {
            builder.addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.locking_option", "somethingHere").setProperty("hibernate.search.default.locking_strategy", "org.hibernate.NotExistingFactory").build();
            builder.close();
            CustomLockProviderTest.fail();
        }
        catch (HibernateException e) {
            Throwable causeSearch = e.getCause();
            CustomLockProviderTest.assertNotNull((Object)causeSearch);
            CustomLockProviderTest.assertTrue((boolean)(causeSearch instanceof SearchException));
            Throwable causeLockin = causeSearch.getCause();
            CustomLockProviderTest.assertNotNull((Object)causeLockin);
            CustomLockProviderTest.assertEquals((String)"Unable to find locking_strategy implementation class: org.hibernate.NotExistingFactory", (String)causeLockin.getMessage());
        }
    }
}

