/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.doubleinsert;

import java.io.Serializable;
import java.util.Date;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.doubleinsert.Address;
import org.hibernate.search.test.embedded.doubleinsert.BusinessContact;
import org.hibernate.search.test.embedded.doubleinsert.Contact;
import org.hibernate.search.test.embedded.doubleinsert.PersonalContact;
import org.hibernate.search.test.embedded.doubleinsert.Phone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleInsertEmbeddedTest
extends SearchTestCase {
    public void testDoubleInsert() throws Exception {
        PersonalContact contact = this.createTestData();
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.getTransaction().begin();
        Term term = new Term("county", "county");
        TermQuery termQuery = new TermQuery(term);
        FullTextQuery query = s.createFullTextQuery((Query)termQuery, new Class[0]);
        DoubleInsertEmbeddedTest.assertEquals((int)1, (int)query.list().size());
        contact = (PersonalContact)s.get(PersonalContact.class, (Serializable)Long.valueOf(contact.getId()));
        contact.getPhoneNumbers().clear();
        contact.getAddresses().clear();
        s.flush();
        s.clear();
        s.createQuery("delete " + Address.class.getName()).executeUpdate();
        s.createQuery("delete " + Phone.class.getName()).executeUpdate();
        s.createQuery("delete " + Contact.class.getName()).executeUpdate();
        s.getTransaction().commit();
        s.close();
    }

    public void testMultipleUpdatesTriggeredByContainedIn() {
        PersonalContact contact = this.createTestData();
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.getTransaction().begin();
        contact = (PersonalContact)s.load(PersonalContact.class, (Serializable)Long.valueOf(contact.getId()));
        contact.setEmail("spam@hibernate.org");
        s.getTransaction().commit();
        s.close();
    }

    public PersonalContact createTestData() {
        Address address = new Address();
        address.setAddress1("TEST1");
        address.setAddress2("N/A");
        address.setTown("TEST TOWN");
        address.setCounty("TEST COUNTY");
        address.setCountry("UK");
        address.setPostcode("XXXXXXX");
        address.setActive(true);
        address.setCreatedOn(new Date());
        address.setLastUpdatedOn(new Date());
        Phone phone = new Phone();
        phone.setNumber("01273234122");
        phone.setType("HOME");
        phone.setCreatedOn(new Date());
        phone.setLastUpdatedOn(new Date());
        PersonalContact contact = new PersonalContact();
        contact.setFirstname("Amin");
        contact.setSurname("Mohammed-Coleman");
        contact.setEmail("address@hotmail.com");
        contact.setDateOfBirth(new Date());
        contact.setNotifyBirthDay(false);
        contact.setCreatedOn(new Date());
        contact.setLastUpdatedOn(new Date());
        contact.setNotes("TEST");
        contact.addAddressToContact(address);
        contact.addPhoneToContact(phone);
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.getTransaction().begin();
        s.save((Object)contact);
        s.getTransaction().commit();
        s.close();
        return contact;
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Phone.class, Contact.class, PersonalContact.class, Address.class, BusinessContact.class};
    }
}

