/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.DocIdBitSet;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.SortedVIntList;
import org.hibernate.search.filter.AndDocIdSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndDocIdSetsTest
extends TestCase {
    static final List<Integer> testDataFrom0to9 = AndDocIdSetsTest.toImmutableList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    static final List<Integer> testDataFrom1to10 = AndDocIdSetsTest.toImmutableList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
    static final List<Integer> testDataFrom1to9 = AndDocIdSetsTest.toImmutableList(1, 2, 3, 4, 5, 6, 7, 8, 9);

    private static List<Integer> toImmutableList(int ... is) {
        ArrayList<Integer> l = new ArrayList<Integer>(is.length);
        for (int i1 : is) {
            l.add(i1);
        }
        return Collections.unmodifiableList(l);
    }

    List<Integer> andLists(List<Integer> ... lists) {
        if (lists.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> result = new ArrayList<Integer>(lists[0]);
        for (int i = 1; i < lists.length; ++i) {
            result.retainAll(lists[i]);
        }
        return result;
    }

    public void testAndingArrays() {
        List<Integer> andLists = this.andLists(testDataFrom0to9, testDataFrom1to10);
        AndDocIdSetsTest.assertTrue((boolean)andLists.containsAll(testDataFrom1to9));
        AndDocIdSetsTest.assertFalse((boolean)andLists.contains(0));
        AndDocIdSetsTest.assertFalse((boolean)andLists.contains(10));
        AndDocIdSetsTest.assertTrue((boolean)((Object)andLists).equals(testDataFrom1to9));
        DocIdSet docIdSet0_9 = this.arrayToDocIdSet(testDataFrom0to9);
        DocIdSet docIdSet1_10 = this.arrayToDocIdSet(testDataFrom1to10);
        DocIdSet docIdSet1_9 = this.arrayToDocIdSet(testDataFrom1to9);
        AndDocIdSetsTest.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(docIdSet0_9, docIdSet0_9));
        AndDocIdSetsTest.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(docIdSet1_10, docIdSet1_10));
        AndDocIdSetsTest.assertFalse((boolean)AndDocIdSetsTest.docIdSetsEqual(docIdSet1_10, docIdSet1_9));
        AndDocIdSetsTest.assertFalse((boolean)AndDocIdSetsTest.docIdSetsEqual(docIdSet0_9, docIdSet1_9));
    }

    public void testIteratorMatchesTestArray() throws IOException {
        DocIdSet docIdSet0_9 = this.arrayToDocIdSet(testDataFrom0to9);
        DocIdSetIterator docIdSetIterator = docIdSet0_9.iterator();
        AndDocIdSetsTest.assertTrue((docIdSetIterator.nextDoc() != Integer.MAX_VALUE ? 1 : 0) != 0);
        AndDocIdSetsTest.assertEquals((int)0, (int)docIdSetIterator.docID());
        AndDocIdSetsTest.assertEquals((int)9, (int)docIdSetIterator.advance(9));
        AndDocIdSetsTest.assertEquals((int)Integer.MAX_VALUE, (int)docIdSetIterator.advance(10));
    }

    public void testAndDocIdSets() {
        ArrayList<DocIdSet> filters = new ArrayList<DocIdSet>(2);
        filters.add(this.arrayToDocIdSet(testDataFrom0to9));
        filters.add(this.arrayToDocIdSet(testDataFrom1to10));
        DocIdSet expected = this.arrayToDocIdSet(testDataFrom1to9);
        AndDocIdSet testedSet = new AndDocIdSet(filters, 10);
        AndDocIdSetsTest.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(expected, (DocIdSet)testedSet));
    }

    public void testOnRandomBigArrays() {
        this.onRandomBigArraysTest(13L);
        this.onRandomBigArraysTest(9L);
        this.onRandomBigArraysTest(71L);
    }

    public void onRandomBigArraysTest(long randomSeed) {
        List<BitSet> filtersData = AndDocIdSetsTest.makeRandomBitSetList(randomSeed, 4, 1000000, 1500000);
        BitSet expectedBitset = AndDocIdSetsTest.applyANDOnBitSets(filtersData);
        List<DocIdSet> filters = AndDocIdSetsTest.toDocIdSetList(filtersData);
        DocIdBitSet expectedDocIdSet = new DocIdBitSet(expectedBitset);
        AndDocIdSet testedSet = new AndDocIdSet(filters, 1500000);
        AndDocIdSetsTest.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual((DocIdSet)expectedDocIdSet, (DocIdSet)testedSet));
    }

    private static List<DocIdSet> toDocIdSetList(List<BitSet> filtersData) {
        ArrayList<DocIdSet> docIdSets = new ArrayList<DocIdSet>(filtersData.size());
        for (BitSet bitSet : filtersData) {
            docIdSets.add((DocIdSet)new DocIdBitSet(bitSet));
        }
        return docIdSets;
    }

    public static void main(String[] args) throws IOException {
        AndDocIdSetsTest.compareAndingPerformance(8, 1000000, 1500000);
        AndDocIdSetsTest.compareAndingPerformance(4, 1000000, 1500000);
        AndDocIdSetsTest.compareAndingPerformance(2, 1000000, 1500000);
        AndDocIdSetsTest.compareAndingPerformance(2, 100000000, 150000000);
        AndDocIdSetsTest.compareAndingPerformance(4, 100000000, 150000000);
        AndDocIdSetsTest.compareAndingPerformance(8, 100000000, 150000000);
    }

    private static void compareAndingPerformance(int listSize, int minBitsSize, int maxBitsSize) throws IOException {
        List<BitSet> filtersData = AndDocIdSetsTest.makeRandomBitSetList(13L, listSize, minBitsSize, maxBitsSize);
        DocIdBitSet andedByBitsResult = null;
        AndDocIdSet andedByIterationResult = null;
        long startTime = System.nanoTime();
        for (int i = 0; i < 1000; ++i) {
            BitSet expectedBitset = AndDocIdSetsTest.applyANDOnBitSets(filtersData);
            andedByBitsResult = new DocIdBitSet(expectedBitset);
            AndDocIdSetsTest.iterateOnResults((DocIdSet)andedByBitsResult);
        }
        long totalTimeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        System.out.println("Time to \"AND " + listSize + " BitSets and iterate on results\" 1000 times: " + totalTimeMs + "ms. (" + minBitsSize + " minimum BitSet size)");
        List<DocIdSet> docIdSetList = AndDocIdSetsTest.toDocIdSetList(filtersData);
        long startTime2 = System.nanoTime();
        for (int i = 0; i < 1000; ++i) {
            andedByIterationResult = new AndDocIdSet(docIdSetList, maxBitsSize);
            AndDocIdSetsTest.iterateOnResults((DocIdSet)andedByIterationResult);
        }
        long totalTimeMs2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime2);
        System.out.println("Time to \"use AndDocIdSet iterator on " + listSize + " Filters and iterate on results\" 1000 times: " + totalTimeMs2 + "ms. (" + minBitsSize + " minimum BitSet size)");
        System.out.println(" Results are same: " + AndDocIdSetsTest.docIdSetsEqual((DocIdSet)andedByBitsResult, (DocIdSet)andedByIterationResult));
    }

    private static void iterateOnResults(DocIdSet docIdBitSet) throws IOException {
        int currentDoc;
        DocIdSetIterator iterator = docIdBitSet.iterator();
        while ((currentDoc = iterator.nextDoc()) != Integer.MAX_VALUE) {
        }
    }

    private static BitSet applyANDOnBitSets(List<BitSet> filtersData) {
        BitSet andedBitSet = null;
        for (BitSet bits : filtersData) {
            if (andedBitSet == null) {
                andedBitSet = (BitSet)bits.clone();
                continue;
            }
            andedBitSet.and(bits);
        }
        return andedBitSet;
    }

    private static List<BitSet> makeRandomBitSetList(long randomSeed, int listSize, int minBitsSize, int maxBitsSize) {
        Random r = new Random(randomSeed);
        ArrayList<BitSet> resultList = new ArrayList<BitSet>(listSize);
        for (int i = 0; i < listSize; ++i) {
            int arraySize = minBitsSize + r.nextInt(maxBitsSize - minBitsSize);
            resultList.add(AndDocIdSetsTest.makeRandomBitSet(r, arraySize));
        }
        return resultList;
    }

    private static BitSet makeRandomBitSet(Random randomSource, int maxSize) {
        BitSet bitSet = new BitSet();
        for (int datai = 0; datai < maxSize; ++datai) {
            if (!randomSource.nextBoolean()) continue;
            bitSet.set(datai);
        }
        return bitSet;
    }

    public DocIdSet arrayToDocIdSet(List<Integer> docIdList) {
        BitSet bitset = new BitSet();
        for (int i : docIdList) {
            bitset.set(i);
        }
        return new DocIdBitSet(bitset);
    }

    public DocIdSet integersToDocIdSet(int ... integers) {
        BitSet bitset = new BitSet();
        for (int i : integers) {
            bitset.set(i);
        }
        return new DocIdBitSet(bitset);
    }

    public static boolean docIdSetsEqual(DocIdSet expected, DocIdSet actual) {
        try {
            int nextA;
            DocIdSetIterator iterA = expected.iterator();
            DocIdSetIterator iterB = actual.iterator();
            do {
                int nextB;
                if ((nextA = iterA.nextDoc()) != (nextB = iterB.nextDoc())) {
                    return false;
                }
                AndDocIdSetsTest.assertEquals((int)iterA.docID(), (int)iterB.docID());
            } while (nextA != Integer.MAX_VALUE);
        }
        catch (IOException ioe) {
            AndDocIdSetsTest.fail((String)"these DocIdSetIterator instances should not throw any exceptions");
        }
        return true;
    }

    public void testWithOpenBitSet() throws IOException {
        OpenBitSet idSet1 = new OpenBitSet(new long[]{1121L}, 1);
        OpenBitSet idSet2 = new OpenBitSet(new long[]{64L}, 1);
        AndDocIdSet actual = this.createAndDocIdSet(new DocIdSet[]{idSet1, idSet2});
        DocIdSet expected = this.integersToDocIdSet(6);
        AndDocIdSetsTest.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(expected, (DocIdSet)actual));
    }

    public void testWithDocIdBitSet() throws IOException {
        DocIdSet idSet1 = this.integersToDocIdSet(0, 5, 6, 10);
        DocIdSet idSet2 = this.integersToDocIdSet(6);
        AndDocIdSet actual = this.createAndDocIdSet(idSet1, idSet2);
        DocIdSet expected = this.integersToDocIdSet(6);
        AndDocIdSetsTest.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(expected, (DocIdSet)actual));
    }

    public void testWithSortedVIntList() throws IOException {
        SortedVIntList idSet1 = new SortedVIntList(new int[]{0, 5, 6, 10});
        SortedVIntList idSet2 = new SortedVIntList(new int[]{6});
        AndDocIdSet actual = this.createAndDocIdSet(new DocIdSet[]{idSet1, idSet2});
        DocIdSet expected = this.integersToDocIdSet(6);
        AndDocIdSetsTest.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(expected, (DocIdSet)actual));
    }

    public void testEmptyDocIdSet() throws Exception {
        DocIdBitSet idSet1 = new DocIdBitSet(new BitSet());
        DocIdSet idSet2 = this.integersToDocIdSet(0, 5, 6, 10);
        AndDocIdSet actual = this.createAndDocIdSet(new DocIdSet[]{idSet1, idSet2});
        DocIdSet expected = DocIdSet.EMPTY_DOCIDSET;
        AndDocIdSetsTest.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(expected, (DocIdSet)actual));
    }

    private AndDocIdSet createAndDocIdSet(DocIdSet ... docIdSets) {
        ArrayList<DocIdSet> list = new ArrayList<DocIdSet>();
        list.addAll(Arrays.asList(docIdSets));
        return new AndDocIdSet(list, 100);
    }
}

