/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import junit.framework.TestCase;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.DocIdBitSet;
import org.apache.lucene.util.OpenBitSet;
import org.hibernate.search.filter.FilterOptimizationHelper;

public class FiltersOptimizationTest
extends TestCase {
    public void testSkipMerging() {
        ArrayList<Object> dataIn = new ArrayList<Object>(3);
        dataIn.add(this.makeOpenBitSetTestSet(1, 2, 3, 5, 8, 9, 10, 11));
        dataIn.add(this.makeBitSetTestSet(1, 2, 3, 5, 8, 9, 10, 11, 20));
        dataIn.add(this.makeAnonymousTestSet(1, 2, 3, 5, 8, 9, 10, 11));
        dataIn.add(this.makeAnonymousTestSet(1, 2, 3, 5, 8, 9, 10, 11, 12));
        List merge = FilterOptimizationHelper.mergeByBitAnds(dataIn);
        FiltersOptimizationTest.assertSame(dataIn, (Object)merge);
    }

    public void testDoMergingOnOpenBitSet() throws IOException {
        ArrayList<Object> dataIn = new ArrayList<Object>(3);
        dataIn.add(this.makeOpenBitSetTestSet(1, 2, 5, 8, 9, 10, 11));
        dataIn.add(this.makeOpenBitSetTestSet(1, 2, 3, 5, 8, 11));
        DocIdSet unmergedSet = this.makeAnonymousTestSet(1, 2, 3, 5, 8, 9, 10, 11);
        dataIn.add(unmergedSet);
        List merge = FilterOptimizationHelper.mergeByBitAnds(dataIn);
        FiltersOptimizationTest.assertNotSame(dataIn, (Object)merge);
        FiltersOptimizationTest.assertEquals((int)2, (int)merge.size());
        FiltersOptimizationTest.assertSame((Object)unmergedSet, merge.get(0));
        FiltersOptimizationTest.assertTrue((boolean)this.isIdSetSequenceSameTo((DocIdSet)merge.get(1), 1, 2, 5, 8, 11));
    }

    public void testDoMergingOnJavaBitSet() throws IOException {
        ArrayList<Object> dataIn = new ArrayList<Object>(3);
        dataIn.add(this.makeBitSetTestSet(1, 2, 5, 8, 9, 10, 11));
        dataIn.add(this.makeBitSetTestSet(1, 2, 3, 5, 8, 11));
        DocIdSet unmergedSet = this.makeAnonymousTestSet(1, 2, 3, 5, 8, 9, 10, 11);
        dataIn.add(unmergedSet);
        List merge = FilterOptimizationHelper.mergeByBitAnds(dataIn);
        FiltersOptimizationTest.assertNotSame(dataIn, (Object)merge);
        FiltersOptimizationTest.assertEquals((int)2, (int)merge.size());
        FiltersOptimizationTest.assertSame((Object)unmergedSet, merge.get(0));
        FiltersOptimizationTest.assertTrue((boolean)this.isIdSetSequenceSameTo((DocIdSet)merge.get(1), 1, 2, 5, 8, 11));
    }

    public void testSelfIdSequenceTester() throws IOException {
        FiltersOptimizationTest.assertTrue((boolean)this.isIdSetSequenceSameTo((DocIdSet)this.makeOpenBitSetTestSet(1, 2, 3, 5, 8, 11), 1, 2, 3, 5, 8, 11));
        FiltersOptimizationTest.assertFalse((boolean)this.isIdSetSequenceSameTo((DocIdSet)this.makeOpenBitSetTestSet(1, 2, 3, 5, 8), 1, 2, 3, 5, 8, 11));
        FiltersOptimizationTest.assertFalse((boolean)this.isIdSetSequenceSameTo((DocIdSet)this.makeOpenBitSetTestSet(1, 2, 3, 5, 8, 11), 1, 2, 3, 5, 8));
    }

    private boolean isIdSetSequenceSameTo(DocIdSet docIdSet, int ... expectedIds) throws IOException {
        DocIdSetIterator idSetIterator = docIdSet.iterator();
        for (int setBit : expectedIds) {
            int currentId = idSetIterator.nextDoc();
            if (currentId == Integer.MAX_VALUE) {
                return false;
            }
            if (currentId == setBit) continue;
            return false;
        }
        return idSetIterator.nextDoc() == Integer.MAX_VALUE;
    }

    private DocIdSet makeAnonymousTestSet(int ... docIds) {
        OpenBitSet idSet = this.makeOpenBitSetTestSet(docIds);
        return new DocIdSetHiddenType((DocIdSet)idSet);
    }

    private OpenBitSet makeOpenBitSetTestSet(int ... enabledBits) {
        OpenBitSet set = new OpenBitSet();
        for (int position : enabledBits) {
            FiltersOptimizationTest.assertFalse((boolean)set.get(position));
            set.set((long)position);
        }
        return set;
    }

    private DocIdBitSet makeBitSetTestSet(int ... enabledBits) {
        BitSet set = new BitSet();
        for (int position : enabledBits) {
            FiltersOptimizationTest.assertFalse((boolean)set.get(position));
            set.set(position);
        }
        return new DocIdBitSet(set);
    }

    private static class DocIdSetHiddenType
    extends DocIdSet {
        private final DocIdSet bitSet;

        DocIdSetHiddenType(DocIdSet wrapped) {
            this.bitSet = wrapped;
        }

        public DocIdSetIterator iterator() throws IOException {
            return this.bitSet.iterator();
        }
    }
}

