/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.reader.functionality;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.test.reader.functionality.TestableSharingBufferReaderProvider;

public class SharingBufferIndexProviderTest
extends TestCase {
    private final TestableSharingBufferReaderProvider readerProvider = new TestableSharingBufferReaderProvider();
    private final CountDownLatch startSignal = new CountDownLatch(1);
    private final Runnable searchTask = new SearchTask();
    private final Runnable changeTask = new ChangeTask();
    private final AtomicInteger countDoneSearches = new AtomicInteger();
    private final AtomicInteger countDoneIndexmods = new AtomicInteger();
    private static final int SEARCHES_NUM = 50000;
    private static final Random random = new Random();

    public void testStressingMock() throws InterruptedException {
        this.readerProvider.initialize(null, null);
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(200);
        for (int i = 0; i < 50000; ++i) {
            executor.execute(this.makeTask(i));
        }
        executor.shutdown();
        this.startSignal.countDown();
        executor.awaitTermination(500L, TimeUnit.SECONDS);
        SharingBufferIndexProviderTest.assertTrue((String)"memory leak: holding a reference to some unused IndexReader", (boolean)this.readerProvider.areAllOldReferencesGone());
        for (TestableSharingBufferReaderProvider.MockIndexReader reader : this.readerProvider.getCreatedIndexReaders()) {
            if (this.readerProvider.isReaderCurrent(reader)) {
                SharingBufferIndexProviderTest.assertTrue((String)"the most current reader should be open", (!reader.isClosed() ? 1 : 0) != 0);
                continue;
            }
            SharingBufferIndexProviderTest.assertTrue((String)"an IndexReader is still open", (boolean)reader.isClosed());
        }
        SharingBufferIndexProviderTest.assertEquals((int)50000, (int)this.countDoneSearches.get());
        SharingBufferIndexProviderTest.assertEquals((int)5000, (int)this.countDoneIndexmods.get());
    }

    private Runnable makeTask(int i) {
        if (i % 10 == 0) {
            return this.changeTask;
        }
        return this.searchTask;
    }

    private DirectoryProvider[] getRandomAvailableDPs() {
        int arraySize = random.nextInt(this.readerProvider.manipulators.size() - 1) + 1;
        DirectoryProvider[] array = new DirectoryProvider[arraySize];
        ArrayList<DirectoryProvider> availableDPs = new ArrayList<DirectoryProvider>(this.readerProvider.directoryProviders);
        for (int i = 0; i < arraySize; ++i) {
            int chosenDpIndex = random.nextInt(availableDPs.size());
            array[i] = (DirectoryProvider)availableDPs.get(chosenDpIndex);
            availableDPs.remove(array[i]);
        }
        return array;
    }

    private class ChangeTask
    extends SearchTask {
        private ChangeTask() {
        }

        public void run() {
            DirectoryProvider[] randomEvailableDPs;
            super.run();
            Thread.yield();
            for (DirectoryProvider dp : randomEvailableDPs = SharingBufferIndexProviderTest.this.getRandomAvailableDPs()) {
                TestableSharingBufferReaderProvider.TestManipulatorPerDP testManipulatorPerDP = ((SharingBufferIndexProviderTest)SharingBufferIndexProviderTest.this).readerProvider.manipulators.get(dp.getDirectory());
                testManipulatorPerDP.setIndexChanged();
            }
            SharingBufferIndexProviderTest.this.countDoneIndexmods.incrementAndGet();
        }
    }

    private class SearchTask
    implements Runnable {
        private SearchTask() {
        }

        public void run() {
            try {
                SharingBufferIndexProviderTest.this.startSignal.await();
            }
            catch (InterruptedException e) {
                return;
            }
            IndexReader fakeOpenReader = SharingBufferIndexProviderTest.this.readerProvider.openReader(SharingBufferIndexProviderTest.this.getRandomAvailableDPs());
            Thread.yield();
            SharingBufferIndexProviderTest.this.readerProvider.closeReader(fakeOpenReader);
            SharingBufferIndexProviderTest.this.countDoneSearches.incrementAndGet();
        }
    }
}

