/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.service;

import junit.framework.TestCase;
import org.hibernate.search.SearchException;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.service.MyServiceProvider;
import org.hibernate.search.test.service.NoServiceDirectoryProvider;
import org.hibernate.search.test.service.ProvidedService;
import org.hibernate.search.test.service.ProvidedServiceDirectoryProvider;
import org.hibernate.search.test.service.ProvidedServiceProvider;
import org.hibernate.search.test.service.ServiceDirectoryProvider;
import org.hibernate.search.test.service.Telephone;
import org.hibernate.search.test.util.ManualConfiguration;

public class ServiceProviderTest
extends TestCase {
    public void testManagedService() throws Exception {
        MyServiceProvider.resetActive();
        ServiceProviderTest.assertNull((Object)MyServiceProvider.isActive());
        ManualConfiguration configuration = new ManualConfiguration();
        configuration.addProperty("hibernate.search.default.directory_provider", ServiceDirectoryProvider.class.getName()).addClass(Telephone.class);
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        ServiceProviderTest.assertTrue((boolean)MyServiceProvider.isActive());
        sf.close();
        ServiceProviderTest.assertFalse((boolean)MyServiceProvider.isActive());
    }

    public void testProvidedService() throws Exception {
        ProvidedServiceProvider.resetActive();
        ServiceProviderTest.assertNull((Object)ProvidedServiceProvider.isActive());
        ManualConfiguration configuration = new ManualConfiguration();
        configuration.addProperty("hibernate.search.default.directory_provider", ProvidedServiceDirectoryProvider.class.getName()).addClass(Telephone.class).getProvidedServices().put(ProvidedServiceProvider.class, new ProvidedService(true));
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        ServiceProviderTest.assertNull((Object)ProvidedServiceProvider.isActive());
        sf.close();
        ServiceProviderTest.assertNull((Object)ProvidedServiceProvider.isActive());
    }

    public void testServiceNotFound() throws Exception {
        ManualConfiguration configuration = new ManualConfiguration();
        configuration.addProperty("hibernate.search.default.directory_provider", NoServiceDirectoryProvider.class.getName()).addClass(Telephone.class);
        boolean exception = false;
        try {
            SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        }
        catch (SearchException e) {
            exception = true;
        }
        ServiceProviderTest.assertTrue((String)"Service not found should raise a SearchException", (boolean)exception);
    }
}

