/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import junit.framework.TestCase;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.query.FullTextFilterImpl;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.RAMDirectoryProvider;
import org.hibernate.search.test.shards.CustomerShardingStrategy;

public class CustomerShardingStrategyTest
extends TestCase {
    private CustomerShardingStrategy shardStrategy;

    protected void setUp() throws Exception {
        this.shardStrategy = new CustomerShardingStrategy();
        this.shardStrategy.initialize(null, new DirectoryProvider[]{new RAMDirectoryProvider(), new RAMDirectoryProvider(), new RAMDirectoryProvider(), new RAMDirectoryProvider(), new RAMDirectoryProvider(), new RAMDirectoryProvider(), new RAMDirectoryProvider(), new RAMDirectoryProvider(), new RAMDirectoryProvider(), new RAMDirectoryProvider()});
    }

    public void testGetDirectoryProvidersForQuery() {
        FullTextFilterImpl filter = new FullTextFilterImpl();
        filter.setName("customer");
        filter.setParameter("customerID", (Object)5);
        DirectoryProvider<?>[] providers = this.shardStrategy.getDirectoryProvidersForQuery((FullTextFilterImplementor[])new FullTextFilterImpl[]{filter});
        CustomerShardingStrategyTest.assertTrue((providers.length == 1 ? 1 : 0) != 0);
        Document document = new Document();
        document.add((Fieldable)new Field("customerID", "5", Field.Store.NO, Field.Index.NOT_ANALYZED));
        CustomerShardingStrategyTest.assertTrue((boolean)providers[0].equals(this.shardStrategy.getDirectoryProviderForAddition(null, null, null, document)));
    }
}

