/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.similarity;

import junit.framework.TestCase;
import org.hibernate.search.test.similarity.Can;
import org.hibernate.search.test.similarity.LittleTrash;
import org.hibernate.search.test.similarity.ProperTrashExtension;
import org.hibernate.search.test.similarity.Sink;
import org.hibernate.search.test.similarity.SmallerCan;
import org.hibernate.search.test.similarity.Trash;
import org.hibernate.search.test.util.FullTextSessionBuilder;

public class IllegalSimilarityConfigurationTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidConfiguration() {
        boolean configurationIsLegal = true;
        FullTextSessionBuilder builder = null;
        try {
            builder = new FullTextSessionBuilder().addAnnotatedClass(Can.class).addAnnotatedClass(Trash.class).build();
        }
        catch (Exception e) {
            configurationIsLegal = false;
        }
        finally {
            if (builder != null) {
                builder.close();
            }
        }
        IllegalSimilarityConfigurationTest.assertTrue((String)"A valid configuration could not be started.", (boolean)configurationIsLegal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInconsistentSimilarityInClassHierarchy() {
        boolean configurationIsLegal = true;
        FullTextSessionBuilder builder = null;
        try {
            builder = new FullTextSessionBuilder().addAnnotatedClass(Trash.class).addAnnotatedClass(LittleTrash.class).build();
        }
        catch (Exception e) {
            configurationIsLegal = false;
        }
        finally {
            if (builder != null) {
                builder.close();
            }
        }
        IllegalSimilarityConfigurationTest.assertFalse((String)"Invalid Similarity declared, should have thrown an exception: same similarity must be used across class hierarchy", (boolean)configurationIsLegal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInconsistentSimilarityInClassSharingAnIndex() {
        boolean configurationIsLegal = true;
        FullTextSessionBuilder builder = null;
        try {
            builder = new FullTextSessionBuilder().addAnnotatedClass(Trash.class).addAnnotatedClass(Sink.class).build();
        }
        catch (Exception e) {
            configurationIsLegal = false;
        }
        finally {
            if (builder != null) {
                builder.close();
            }
        }
        IllegalSimilarityConfigurationTest.assertFalse((String)"Invalid Similarity declared, should have thrown an exception: two entitiessharing the same index are using a different similarity", (boolean)configurationIsLegal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImplicitSimilarityInheritanceIsValid() {
        boolean configurationIsLegal = true;
        FullTextSessionBuilder builder = null;
        try {
            builder = new FullTextSessionBuilder().addAnnotatedClass(Trash.class).addAnnotatedClass(ProperTrashExtension.class).build();
        }
        catch (Exception e) {
            configurationIsLegal = false;
        }
        finally {
            if (builder != null) {
                builder.close();
            }
        }
        IllegalSimilarityConfigurationTest.assertTrue((String)"Valid configuration could not be built", (boolean)configurationIsLegal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidToOverrideParentsSimilarity() {
        boolean configurationIsLegal = true;
        FullTextSessionBuilder builder = null;
        try {
            builder = new FullTextSessionBuilder().addAnnotatedClass(Can.class).addAnnotatedClass(SmallerCan.class).build();
        }
        catch (Exception e) {
            configurationIsLegal = false;
        }
        finally {
            if (builder != null) {
                builder.close();
            }
        }
        IllegalSimilarityConfigurationTest.assertFalse((String)"Invalid Similarity declared, should have thrown an exception: child entity is overriding parent's Similarity", (boolean)configurationIsLegal);
    }
}

