/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.hibernate.search.util.FileHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class FileHelperTest
extends TestCase {
    private static final Logger log = LoggerFactory.make();
    private static File root;
    private String srcDir = "filehelpersrc";
    private String destDir = "filehelperdest";

    private File createFile(File dir, String name) throws IOException {
        File file = new File(dir, name);
        file.createNewFile();
        this.writeDummyDataToFile(file);
        return file;
    }

    private void writeDummyDataToFile(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file, true);
        os.write(1);
        os.write(2);
        os.write(3);
        os.flush();
        os.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        File dir = new File(root, this.srcDir);
        FileHelper.delete((File)dir);
        dir = new File(root, this.destDir);
        FileHelper.delete((File)dir);
        FileHelper.delete((File)root);
    }

    public void testSynchronize() throws Exception {
        File src = new File(root, this.srcDir);
        src.mkdirs();
        String name = "a";
        this.createFile(src, name);
        name = "b";
        this.createFile(src, name);
        File subDir = new File(src, "subdir");
        subDir.mkdirs();
        name = "c";
        this.createFile(subDir, name);
        File dest = new File(root, this.destDir);
        FileHelperTest.assertFalse((String)"Directories should be out of sync", (boolean)FileHelper.areInSync((File)src, (File)dest));
        FileHelper.synchronize((File)src, (File)dest, (boolean)true);
        FileHelperTest.assertTrue((String)"Directories should be in sync", (boolean)FileHelper.areInSync((File)src, (File)dest));
        File destTestFile1 = new File(dest, "b");
        FileHelperTest.assertTrue((boolean)destTestFile1.exists());
        File destTestFile2 = new File(new File(dest, "subdir"), "c");
        FileHelperTest.assertTrue((boolean)destTestFile2.exists());
        File destTestFile3 = this.createFile(dest, "foo");
        File srcTestFile = new File(src, "c");
        this.writeDummyDataToFile(srcTestFile);
        File destTestFile = new File(dest, "c");
        FileHelperTest.assertNotSame((Object)srcTestFile.lastModified(), (Object)destTestFile.lastModified());
        FileHelperTest.assertFalse((String)"Directories should be out of sync", (boolean)FileHelper.areInSync((File)src, (File)dest));
        FileHelper.synchronize((File)src, (File)dest, (boolean)true);
        FileHelperTest.assertTrue((String)"Directories should be in sync", (boolean)FileHelper.areInSync((File)src, (File)dest));
        FileHelperTest.assertEquals((long)srcTestFile.lastModified(), (long)destTestFile.lastModified());
        FileHelperTest.assertEquals((long)srcTestFile.length(), (long)destTestFile.length());
        FileHelperTest.assertTrue((boolean)destTestFile1.exists());
        FileHelperTest.assertTrue((boolean)destTestFile2.exists());
        FileHelperTest.assertTrue((!destTestFile3.exists() ? 1 : 0) != 0);
        srcTestFile.delete();
        FileHelper.synchronize((File)src, (File)dest, (boolean)true);
        FileHelperTest.assertTrue((!destTestFile.exists() ? 1 : 0) != 0);
        FileHelperTest.assertTrue((String)"Directories should be in sync", (boolean)FileHelper.areInSync((File)src, (File)dest));
    }

    static {
        String buildDir = System.getProperty("build.dir");
        if (buildDir == null) {
            buildDir = ".";
        }
        root = new File(buildDir, "filehelper");
        log.info("Using {} as test directory.", (Object)root.getAbsolutePath());
    }
}

