/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.io.File;
import org.apache.lucene.analysis.StopAnalyzer;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cache.HashtableCacheProvider;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.util.FileHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class FullTextSessionBuilder {
    private static final Logger log = LoggerFactory.make();
    private static final File indexDir;
    private Configuration cfg = new Configuration();
    private SessionFactory sessionFactory;
    private boolean usingFileSystem = false;

    public FullTextSessionBuilder() {
        this.cfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        this.cfg.setProperty("hibernate.cache.use_second_level_cache", "true");
        this.cfg.setProperty("hibernate.cache.provider_class", HashtableCacheProvider.class.getCanonicalName());
        this.cfg.setProperty("hibernate.cache.use_query_cache", "true");
        this.cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
        this.useRAMDirectoryProvider(true);
    }

    public FullTextSessionBuilder useRAMDirectoryProvider(boolean use) {
        if (use) {
            this.cfg.setProperty("hibernate.search.default.directory_provider", "ram");
            this.usingFileSystem = false;
        } else {
            this.cfg.setProperty("hibernate.search.default.directory_provider", "filesystem");
            this.usingFileSystem = true;
        }
        return this;
    }

    public FullTextSessionBuilder setProperty(String key, String value) {
        this.cfg.setProperty(key, value);
        return this;
    }

    public FullTextSessionBuilder addAnnotatedClass(Class annotatedClass) {
        this.cfg.addAnnotatedClass(annotatedClass);
        return this;
    }

    public FullTextSession openFullTextSession() {
        if (this.sessionFactory == null) {
            this.build();
        }
        org.hibernate.classic.Session session = this.sessionFactory.openSession();
        return Search.getFullTextSession((Session)session);
    }

    public void close() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("sessionFactory not yet built");
        }
        this.sessionFactory.close();
        if (this.usingFileSystem) {
            FileHelper.delete((File)indexDir);
        }
        this.sessionFactory = null;
    }

    public FullTextSessionBuilder build() {
        this.sessionFactory = this.cfg.buildSessionFactory();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchFactory getSearchFactory() {
        FullTextSession fullTextSession = this.openFullTextSession();
        try {
            SearchFactory searchFactory = fullTextSession.getSearchFactory();
            return searchFactory;
        }
        finally {
            fullTextSession.close();
        }
    }

    static {
        String buildDir = System.getProperty("build.dir");
        if (buildDir == null) {
            buildDir = ".";
        }
        File current = new File(buildDir);
        indexDir = new File(current, "indextemp");
        log.debug("Using {} as index directory.", (Object)indexDir.getAbsolutePath());
    }
}

