/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import junit.framework.Assert;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.SearchException;
import org.hibernate.search.test.batchindexing.Book;
import org.hibernate.search.test.batchindexing.Nation;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Test;

public class BatchBackendConfigurationTest {
    @Test
    public void testConfigurationIsRead() throws InterruptedException {
        FullTextSessionBuilder fsBuilder = new FullTextSessionBuilder().addAnnotatedClass(Book.class).addAnnotatedClass(Nation.class).setProperty("hibernate.search.batchbackend.concurrent_writers", "0").build();
        FullTextSession fullTextSession = fsBuilder.openFullTextSession();
        MassIndexer massIndexer = fullTextSession.createIndexer(new Class[0]);
        try {
            massIndexer.startAndWait();
            Assert.fail((String)"should have thrown an exception as configuration is illegal");
        }
        catch (SearchException e) {
            // empty catch block
        }
        fullTextSession.close();
        fsBuilder.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigurationIsOverriden() throws InterruptedException {
        FullTextSessionBuilder fsBuilder = new FullTextSessionBuilder().addAnnotatedClass(Book.class).addAnnotatedClass(Nation.class).setProperty("hibernate.search.batchbackend.concurrent_writers", "0").build();
        try {
            FullTextSession fullTextSession = fsBuilder.openFullTextSession();
            MassIndexer massIndexer = fullTextSession.createIndexer(new Class[0]);
            massIndexer.threadsForIndexWriter(2);
            massIndexer.startAndWait();
            fullTextSession.close();
        }
        finally {
            fsBuilder.close();
        }
    }
}

