/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import junit.framework.Assert;
import org.apache.solr.analysis.LowerCaseFilterFactory;
import org.apache.solr.analysis.StandardTokenizerFactory;
import org.apache.solr.analysis.StopFilterFactory;
import org.hibernate.HibernateException;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.test.configuration.User;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Test;

public class ResourceNotFoundMessageTest {
    @Test
    public void testIllegalAnalyzerDefinition() {
        try {
            new FullTextSessionBuilder().addAnnotatedClass(User.class).setProperty("hibernate.search.model_mapping", ResourceNotFoundMessageTest.class.getName()).build();
            Assert.fail((String)"should not reach this");
        }
        catch (HibernateException initException) {
            Throwable causeException = initException.getCause();
            Assert.assertTrue((boolean)(causeException instanceof SearchException));
            SearchException searchException = (SearchException)causeException;
            String message = searchException.getMessage();
            Assert.assertEquals((String)"Resource not found: non-existent-resourcename.file", (String)message);
        }
    }

    @Factory
    public SearchMapping build() {
        SearchMapping mapping = new SearchMapping();
        mapping.analyzerDef("ngram", StandardTokenizerFactory.class).filter(LowerCaseFilterFactory.class).filter(StopFilterFactory.class).param("words", "non-existent-resourcename.file");
        return mapping;
    }
}

