/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.doubleinsert;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.embedded.doubleinsert.Address;
import org.hibernate.search.test.embedded.doubleinsert.Phone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="T_CONTACT")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorValue(value="Contact")
@DiscriminatorColumn(name="contactType", discriminatorType=DiscriminatorType.STRING)
@Indexed
public class Contact
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="C_CONTACT_ID")
    @DocumentId
    private long id;
    @Column(name="C_EMAIL")
    @Field(index=Index.TOKENIZED, store=Store.YES)
    private String email;
    @Column(name="C_CREATEDON")
    @Type(type="java.util.Date")
    private Date createdOn;
    @Column(name="C_LASTUPDATEDON")
    @Type(type="java.util.Date")
    private Date lastUpdatedOn;
    @ContainedIn
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Type(type="java.util.Set")
    private Set<Address> addresses;
    @ContainedIn
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Type(type="java.util.Set")
    private Set<Phone> phoneNumbers;
    @Column(name="C_NOTES")
    private String notes;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getEmail() {
        if (null == this.email || "".equals(this.email)) {
            return "N/A";
        }
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        this.lastUpdatedOn = lastUpdatedOn;
    }

    public Set<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Set<Address> addresses) {
        this.addresses = addresses;
    }

    public Set<Phone> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(Set<Phone> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void addAddressToContact(Address address) {
        if (address == null) {
            throw new IllegalArgumentException("Address cannot be null");
        }
        if (this.addresses == null) {
            this.addresses = new HashSet<Address>();
        }
        address.setContact(this);
        this.addresses.add(address);
    }

    public void addPhoneToContact(Phone phone) {
        if (phone == null) {
            throw new IllegalArgumentException("Phone cannot be null");
        }
        if (this.phoneNumbers == null) {
            this.phoneNumbers = new HashSet<Phone>();
        }
        phone.setContact(this);
        this.phoneNumbers.add(phone);
    }

    public void removePhoneFromContact(Phone phone) {
        if (phone == null) {
            throw new IllegalArgumentException("Phone cannot be null");
        }
        if (this.phoneNumbers.contains(phone)) {
            this.phoneNumbers.remove(phone);
        }
    }

    public void removeAddressFromContact(Address address) {
        if (address == null) {
            throw new IllegalArgumentException("Address cannot be null");
        }
        if (this.addresses.contains(address)) {
            this.addresses.remove(address);
        }
    }

    protected List<Phone> filterPhoneNumbersByType(final String phoneType) {
        return (List)CollectionUtils.select(this.phoneNumbers, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Phone phone = (Phone)object;
                return phoneType.equals(phone.getType());
            }
        });
    }

    protected List<Address> showActiveAddresses() {
        return (List)CollectionUtils.select(this.addresses, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Address address = (Address)object;
                return address.isActive();
            }
        });
    }

    protected List<Address> showInactiveAddresses() {
        return (List)CollectionUtils.select(this.addresses, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Address address = (Address)object;
                return !address.isActive();
            }
        });
    }

    protected void displayPhonesAndAddresses(StringBuilder buf) {
    }
}

