/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.jgroups.common.MultipleSessionsSearchTestCase;
import org.hibernate.search.test.jgroups.master.TShirt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGroupsCommonTest
extends MultipleSessionsSearchTestCase {
    private static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "testing-flush-udp.xml";
    public static final long NETWORK_TIMEOUT = 50L;

    public void testJGroupsBackend() throws Exception {
        org.hibernate.classic.Session s = this.getSlaveSession();
        Transaction tx = s.beginTransaction();
        TShirt ts = new TShirt();
        ts.setLogo("Boston");
        ts.setSize("XXL");
        TShirt ts2 = new TShirt();
        ts2.setLogo("Mapple leaves");
        ts2.setSize("L");
        s.persist((Object)ts);
        s.persist((Object)ts2);
        tx.commit();
        Thread.sleep(50L);
        FullTextSession ftSess = Search.getFullTextSession((Session)this.openSession());
        ftSess.getTransaction().begin();
        QueryParser parser = new QueryParser(JGroupsCommonTest.getTargetLuceneVersion(), "id", SearchTestCase.stopAnalyzer);
        Query luceneQuery = parser.parse("logo:Boston or logo:Mapple leaves");
        FullTextQuery query = ftSess.createFullTextQuery(luceneQuery, new Class[0]);
        List result = query.list();
        JGroupsCommonTest.assertEquals((int)2, (int)result.size());
        s = this.getSlaveSession();
        tx = s.beginTransaction();
        ts = (TShirt)s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId()));
        ts.setLogo("Peter pan");
        tx.commit();
        Thread.sleep(50L);
        luceneQuery = parser.parse("logo:Peter pan");
        query = ftSess.createFullTextQuery(luceneQuery, new Class[0]);
        result = query.list();
        JGroupsCommonTest.assertEquals((int)1, (int)result.size());
        s = this.getSlaveSession();
        tx = s.beginTransaction();
        s.delete(s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId())));
        s.delete(s.get(TShirt.class, (Serializable)Integer.valueOf(ts2.getId())));
        tx.commit();
        Thread.sleep(50L);
        luceneQuery = parser.parse("logo:Boston or logo:Mapple leaves");
        query = ftSess.createFullTextQuery(luceneQuery, new Class[0]);
        result = query.list();
        JGroupsCommonTest.assertEquals((int)0, (int)result.size());
        ftSess.getTransaction().commit();
        ftSess.close();
        s.close();
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.worker.backend", "jgroupsMaster");
        cfg.setProperty("hibernate.search.worker.backend.jgroups.configurationFile", DEFAULT_JGROUPS_CONFIGURATION_FILE);
    }

    @Override
    protected void commonConfigure(Configuration cfg) {
        super.commonConfigure(cfg);
        cfg.setProperty("hibernate.search.worker.backend", "jgroupsSlave");
        cfg.setProperty("hibernate.search.worker.backend.jgroups.configurationFile", DEFAULT_JGROUPS_CONFIGURATION_FILE);
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }

    @Override
    protected Class<?>[] getCommonAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }
}

