/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.explain;

import java.util.HashMap;
import java.util.List;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.query.explain.Dvd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplanationTest
extends SearchTestCase {
    public void testExplanation() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Dvd dvd = new Dvd("The dark knight", "Batman returns with his best enemy the Joker. The dark side of this movies shows up pretty quickly");
        s.persist((Object)dvd);
        dvd = new Dvd("Wall-e", "The tiny little robot comes to Earth after the dark times and tries to clean it");
        s.persist((Object)dvd);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        HashMap<String, Float> boosts = new HashMap<String, Float>(2);
        boosts.put("title", new Float(4.0f));
        boosts.put("description", new Float(1.0f));
        MultiFieldQueryParser parser = new MultiFieldQueryParser(ExplanationTest.getTargetLuceneVersion(), new String[]{"title", "description"}, SearchTestCase.standardAnalyzer, boosts);
        Query luceneQuery = parser.parse("dark");
        FullTextQuery ftQuery = s.createFullTextQuery(luceneQuery, new Class[]{Dvd.class}).setProjection(new String[]{"__HSearch_DocumentId", "__HSearch_Explanation", "__HSearch_This"});
        List results = ftQuery.list();
        ExplanationTest.assertEquals((int)2, (int)results.size());
        for (Object[] result : results) {
            ExplanationTest.assertEquals((String)ftQuery.explain(((Integer)result[0]).intValue()).toString(), (String)result[1].toString());
            s.delete(result[2]);
        }
        tx.commit();
        s.close();
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Dvd.class};
    }
}

