/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.Version;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.batchlucene.BatchBackend;
import org.hibernate.search.backend.impl.batchlucene.LuceneBatchBackend;
import org.hibernate.search.impl.FullTextSessionImpl;
import org.hibernate.search.test.util.BarAnalyzer;
import org.hibernate.search.test.util.FooAnalyzer;
import org.hibernate.search.util.ClassLoaderHelper;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderHelperTest {
    @Test
    public void testInstanceFromName() {
        BatchBackend batchBackend = (BatchBackend)ClassLoaderHelper.instanceFromName(BatchBackend.class, (String)LuceneBatchBackend.class.getName(), this.getClass(), (String)"Lucene batch backend");
        Assert.assertNotNull((Object)batchBackend);
        Assert.assertTrue((boolean)batchBackend.getClass().equals(LuceneBatchBackend.class));
        try {
            ClassLoaderHelper.instanceFromName(BackendQueueProcessorFactory.class, (String)"HeyThisClassIsNotThere", this.getClass(), (String)"backend");
            Assert.fail((String)"was expecting a SearchException");
        }
        catch (Exception e) {
            Assert.assertEquals(e.getClass(), SearchException.class);
            Assert.assertEquals((Object)"Unable to find backend implementation class: HeyThisClassIsNotThere", (Object)e.getMessage());
        }
    }

    @Test
    public void testInstanceFromClass() {
        BatchBackend batchBackend = (BatchBackend)ClassLoaderHelper.instanceFromClass(BatchBackend.class, LuceneBatchBackend.class, (String)"Lucene batch backend");
        Assert.assertNotNull((Object)batchBackend);
        Assert.assertTrue((boolean)batchBackend.getClass().equals(LuceneBatchBackend.class));
        Similarity sim = (Similarity)ClassLoaderHelper.instanceFromClass(Similarity.class, DefaultSimilarity.class, (String)"default similarity");
        Assert.assertNotNull((Object)sim);
        Assert.assertTrue((boolean)sim.getClass().equals(DefaultSimilarity.class));
        this.wrappingTestFromClass("Wrong configuration of Lucene batch backend: class org.hibernate.search.test.util.ClassLoaderHelperTest does not implement interface org.hibernate.search.backend.impl.batchlucene.BatchBackend", BatchBackend.class, ClassLoaderHelperTest.class, "Lucene batch backend");
        this.wrappingTestFromClass("org.hibernate.search.impl.FullTextSessionImpl defined for component session is missing a no-arguments constructor", FullTextSession.class, FullTextSessionImpl.class, "session");
        this.wrappingTestFromClass("org.hibernate.Session defined for component session is an interface: implementation required.", FullTextSession.class, Session.class, "session");
        this.wrappingTestFromClass("Wrong configuration of default similarity: class org.hibernate.search.backend.impl.batchlucene.LuceneBatchBackend is not a subtype of org.apache.lucene.search.Similarity", Similarity.class, LuceneBatchBackend.class, "default similarity");
        this.wrappingTestFromClass("Unable to instantiate default similarity class: org.apache.lucene.search.Similarity. Verify it has a no-args public constructor and is not abstract.", Similarity.class, Similarity.class, "default similarity");
    }

    @Test
    public void testLoadingAnalyzerWithVersionConstructor() {
        Analyzer analyzer = ClassLoaderHelper.analyzerInstanceFromClass(StandardAnalyzer.class, (Version)Version.LUCENE_30);
        Assert.assertNotNull((String)"We should be able to instantiate an analyzer with a Lucene version parameter", (Object)analyzer);
    }

    @Test
    public void testLoadingAnalyzerWithDefaultConstructor() {
        Analyzer analyzer = ClassLoaderHelper.analyzerInstanceFromClass(FooAnalyzer.class, (Version)Version.LUCENE_30);
        Assert.assertNotNull((String)"We should be able to instantiate an analyzer which has only a default constructor", (Object)analyzer);
    }

    @Test
    public void testLoadingAnalyzerWithNoVersionOrDefaultConstructor() {
        try {
            ClassLoaderHelper.analyzerInstanceFromClass(BarAnalyzer.class, (Version)Version.LUCENE_30);
            Assert.fail((String)"We should not be able to instantiate a analyzer with no default constructor or simple Version parameter.");
        }
        catch (SearchException e) {
            Assert.assertEquals(((Object)((Object)e)).getClass(), SearchException.class);
            Assert.assertEquals((Object)"Unable to instantiate analyzer class: org.hibernate.search.test.util.BarAnalyzer. Class neither has a default constructor nor a constructor with a Version parameter", (Object)e.getMessage());
        }
    }

    private void wrappingTestFromClass(String expectedErrorMessage, Class<?> interf, Class<?> impl, String componentName) {
        try {
            ClassLoaderHelper.instanceFromClass(interf, impl, (String)componentName);
            Assert.fail((String)"was expecting a SearchException");
        }
        catch (Exception e) {
            Assert.assertEquals(e.getClass(), SearchException.class);
            Assert.assertEquals((Object)expectedErrorMessage, (Object)e.getMessage());
        }
    }
}

