/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.spi.ServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalSearchConfiguration
implements SearchConfiguration {
    private final ReflectionManager reflectionManager = new JavaReflectionManager();
    private final List<Class<?>> classes;
    private final Map<String, Class<?>> classesByName = new HashMap();
    private Properties properties;

    public IncrementalSearchConfiguration(List<Class<?>> classes, Properties properties) {
        this.properties = properties;
        this.classes = classes;
        for (Class<?> entity : classes) {
            this.classesByName.put(entity.getName(), entity);
        }
    }

    @Override
    public Iterator<Class<?>> getClassMappings() {
        return this.classes.iterator();
    }

    @Override
    public Class<?> getClassMapping(String name) {
        return this.classesByName.get(name);
    }

    @Override
    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public ReflectionManager getReflectionManager() {
        return this.reflectionManager;
    }

    @Override
    public SearchMapping getProgrammaticMapping() {
        return null;
    }

    @Override
    public Map<Class<? extends ServiceProvider<?>>, Object> getProvidedServices() {
        return Collections.emptyMap();
    }
}

