/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.collector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.dsl.impl.RangeFacetImpl;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.fieldcache.FieldCacheLoadingType;
import org.hibernate.search.query.fieldcache.FieldLoadingStrategy;
import org.hibernate.search.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetCollector
extends Collector {
    private final Collector delegate;
    private final FacetingRequestImpl facetRequest;
    private final FieldLoadingStrategy fieldLoader;
    private final FacetCounter facetCounts;
    private boolean initialised = false;

    public FacetCollector(Collector delegate, FacetingRequestImpl facetRequest) {
        this.delegate = delegate;
        this.facetRequest = facetRequest;
        this.facetCounts = this.createFacetCounter(facetRequest);
        this.fieldLoader = FieldCacheLoadingType.getLoadingStrategy(this.facetRequest.getFieldName(), this.facetRequest.getFieldCacheType());
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        if (!this.initialised) {
            this.initialiseCollector(reader);
        }
        this.initialiseFieldCaches(reader);
        this.delegate.setNextReader(reader, docBase);
    }

    public void collect(int doc) throws IOException {
        Object value = this.fieldLoader.collect(doc);
        if (value != null) {
            this.facetCounts.countValue(value);
        }
        this.delegate.collect(doc);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.delegate.acceptsDocsOutOfOrder();
    }

    public String getFacetName() {
        return this.facetRequest.getFacetingName();
    }

    public List<Facet> getFacetList() {
        return this.createSortedFacetList(this.facetCounts, this.facetRequest);
    }

    private List<Facet> createSortedFacetList(FacetCounter counter, FacetingRequestImpl request) {
        ArrayList<Facet> facetList = CollectionHelper.newArrayList();
        int includedFacetCount = 0;
        for (Map.Entry<String, Integer> countEntry : counter.getCounts().entrySet()) {
            Facet facet = request.createFacet(countEntry.getKey(), countEntry.getValue());
            if (!request.hasZeroCountsIncluded() && facet.getCount() == 0) continue;
            if (this.facetRequest.getMaxNumberOfFacets() > 0 && includedFacetCount == this.facetRequest.getMaxNumberOfFacets()) break;
            facetList.add(facet);
            ++includedFacetCount;
        }
        Collections.sort(facetList, new FacetComparator(request.getSort()));
        return facetList;
    }

    private void initialiseCollector(IndexReader reader) throws IOException {
        if (this.facetRequest.hasZeroCountsIncluded() && this.facetRequest instanceof DiscreteFacetRequest) {
            this.initFacetCounts(reader);
        }
        this.initialised = true;
    }

    private void initialiseFieldCaches(IndexReader reader) throws IOException {
        this.fieldLoader.loadNewCacheValues(reader);
    }

    private <N extends Number> FacetCounter createFacetCounter(FacetingRequestImpl request) {
        if (request instanceof DiscreteFacetRequest) {
            return new SimpleFacetCounter();
        }
        if (request instanceof RangeFacetRequest) {
            RangeFacetRequest rangeFacetRequest = (RangeFacetRequest)request;
            return new RangeFacetCounter(rangeFacetRequest);
        }
        throw new IllegalArgumentException("Unsupported cache type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFacetCounts(IndexReader reader) throws IOException {
        String fieldName = this.facetRequest.getFieldName();
        TermEnum terms = reader.terms(new Term(fieldName, ""));
        try {
            while (fieldName.equals(terms.term().field())) {
                String fieldValue = terms.term().text();
                this.facetCounts.initCount(fieldValue);
                if (terms.next()) continue;
                break;
            }
        }
        finally {
            terms.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RangeFacetCounter<T>
    extends FacetCounter {
        private final List<FacetRange<T>> ranges;

        RangeFacetCounter(RangeFacetRequest<T> request) {
            this.ranges = request.getFacetRangeList();
            for (FacetRange<T> range : this.ranges) {
                this.initCount(range.getRangeString());
            }
        }

        @Override
        void countValue(Object value) {
            for (FacetRange<Object> facetRange : this.ranges) {
                if (!facetRange.isInRange(value)) continue;
                this.incrementCount(facetRange.getRangeString());
            }
        }
    }

    static class SimpleFacetCounter
    extends FacetCounter {
        SimpleFacetCounter() {
        }

        void countValue(Object value) {
            this.incrementCount((String)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class FacetCounter {
        private Map<String, Integer> counts = CollectionHelper.newHashMap();

        Map<String, Integer> getCounts() {
            return this.counts;
        }

        void initCount(String value) {
            if (!this.counts.containsKey(value)) {
                this.counts.put(value, 0);
            }
        }

        void incrementCount(String value) {
            if (!this.counts.containsKey(value)) {
                this.counts.put(value, 1);
            } else {
                this.counts.put(value, this.counts.get(value) + 1);
            }
        }

        abstract void countValue(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FacetComparator
    implements Comparator<Facet> {
        private final FacetSortOrder sortOder;

        public FacetComparator(FacetSortOrder sortOrder) {
            this.sortOder = sortOrder;
        }

        @Override
        public int compare(Facet facet1, Facet facet2) {
            if (FacetSortOrder.COUNT_ASC.equals((Object)this.sortOder)) {
                return facet1.getCount() - facet2.getCount();
            }
            if (FacetSortOrder.COUNT_DESC.equals((Object)this.sortOder)) {
                return facet2.getCount() - facet1.getCount();
            }
            if (FacetSortOrder.RANGE_DEFINITION_ODER.equals((Object)this.sortOder)) {
                return ((RangeFacetImpl)facet1).getRangeIndex() - ((RangeFacetImpl)facet2).getRangeIndex();
            }
            return facet1.getValue().compareTo(facet2.getValue());
        }
    }
}

